/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.utils.TypeUtils;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.editor.AbstractColorMapPanel;
import com.macrofocus.colormap.editor.ColorMapPanel;
import com.macrofocus.colormap.editor.ColorMapPanelModel;
import com.macrofocus.colormap.swing.ColorMapState;
import com.macrofocus.colormap.swing.SwingCategoricalColorMapEditor;
import com.macrofocus.colormap.swing.SwingCustomColorMapEditor;
import com.macrofocus.colormap.swing.SwingPredefinedColorMapEditor;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJRadioButton;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.util.swing.print.CopyAction;
import com.macrofocus.util.swing.print.ExportComponentAction;
import com.macrofocus.util.swing.print.PrintComponentAction;
import de.javasoft.syntheticaaddons.SimpleDropDownButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;

public class SwingColorMapPanel<C>
extends AbstractColorMapPanel<C, JComponent, Color> {
    private JPanel mainPanel;
    private JRadioButton categoricalRadioButton;
    private JRadioButton customRadioButton;
    private JRadioButton predefinedRadioButton;
    private JPanel editorPanel;
    private JPanel typeButtonPanel;
    private SimpleDropDownButton dropDownButton;
    private final SwingCategoricalColorMapEditor categoricalColorMapEditor;
    private final SwingCustomColorMapEditor customColorMapEditor;
    private final SwingPredefinedColorMapEditor predefinedColorMapEditor;

    protected void updateSelectedVariable() {
        boolean numericType;
        Object field = this.model.getColorSelection().getSelected();
        boolean bl = numericType = field != null && (TypeUtils.isNumericType((Class)this.model.getType(field)) || TypeUtils.isTemporalType((Class)this.model.getType(field)));
        if (this.model.getCurrentColorMap(field) != null && this.model.getCategoricalColorMap(field) == this.model.getCurrentColorMap(field)) {
            this.categoricalRadioButton.setSelected(true);
        } else if (this.model.getCurrentColorMap(field) != null && this.model.getCustomColorMap(field) == this.model.getCurrentColorMap(field)) {
            this.customRadioButton.setSelected(true);
        } else if (this.model.getCurrentColorMap(field) != null && this.model.getPredefinedColorMap(field) == this.model.getCurrentColorMap(field)) {
            this.predefinedRadioButton.setSelected(true);
        } else if (numericType) {
            this.predefinedRadioButton.setSelected(true);
        } else {
            this.categoricalRadioButton.setSelected(true);
        }
        this.categoricalRadioButton.setEnabled(!numericType || field != null && this.model.getType(field) == Integer.class);
        this.predefinedRadioButton.setEnabled(numericType);
        this.customRadioButton.setEnabled(numericType);
        this.mainPanel.setVisible(field != null);
    }

    public SwingColorMapPanel(boolean expertMode) {
        this(null, null, null, expertMode);
    }

    public SwingColorMapPanel(final JComponent legendContainer, JComponent legend, final Action[] actions, final boolean expertMode) {
        this.categoricalColorMapEditor = new SwingCategoricalColorMapEditor(actions, expertMode);
        this.customColorMapEditor = new SwingCustomColorMapEditor(false, expertMode);
        this.predefinedColorMapEditor = new SwingPredefinedColorMapEditor(false, expertMode);
        this.$$$setupUI$$$();
        if (legend != null) {
            this.predefinedColorMapEditor.getLegend().setScreenShotComponent(legend);
            this.customColorMapEditor.getLegend().setScreenShotComponent(legend);
        }
        this.categoricalRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JScrollPane root;
                SwingColorMapPanel.this.editorPanel.removeAll();
                SwingColorMapPanel.this.editorPanel.add((Component)SwingColorMapPanel.this.categoricalColorMapEditor.getNativeComponent(), "Center");
                SwingColorMapPanel.this.editorPanel.validate();
                SwingColorMapPanel.this.editorPanel.repaint();
                if (legendContainer != null) {
                    legendContainer.removeAll();
                    legendContainer.validate();
                    legendContainer.repaint();
                }
                if ((root = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, SwingColorMapPanel.this.editorPanel)) != null) {
                    root.revalidate();
                }
                SwingColorMapPanel.this.updateColorMap();
            }
        });
        this.customRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JScrollPane root;
                SwingColorMapPanel.this.editorPanel.removeAll();
                SwingColorMapPanel.this.editorPanel.add((Component)SwingColorMapPanel.this.customColorMapEditor.getNativeComponent(), "Center");
                SwingColorMapPanel.this.editorPanel.validate();
                SwingColorMapPanel.this.editorPanel.repaint();
                if (legendContainer != null) {
                    legendContainer.removeAll();
                    legendContainer.setLayout(new OverlayLayout(legendContainer));
                    legendContainer.add((Component)SwingColorMapPanel.this.customColorMapEditor.getLegend());
                    legendContainer.validate();
                    legendContainer.repaint();
                }
                if ((root = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, SwingColorMapPanel.this.editorPanel)) != null) {
                    root.revalidate();
                }
                SwingColorMapPanel.this.updateColorMap();
            }
        });
        this.predefinedRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JScrollPane root;
                SwingColorMapPanel.this.editorPanel.removeAll();
                SwingColorMapPanel.this.editorPanel.add((Component)SwingColorMapPanel.this.predefinedColorMapEditor.getNativeComponent(), "Center");
                SwingColorMapPanel.this.editorPanel.validate();
                SwingColorMapPanel.this.editorPanel.repaint();
                if (legendContainer != null) {
                    legendContainer.removeAll();
                    legendContainer.setLayout(new OverlayLayout(legendContainer));
                    legendContainer.add((Component)SwingColorMapPanel.this.predefinedColorMapEditor.getLegend());
                    legendContainer.validate();
                    legendContainer.repaint();
                }
                if ((root = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, SwingColorMapPanel.this.editorPanel)) != null) {
                    root.revalidate();
                }
                SwingColorMapPanel.this.updateColorMap();
            }
        });
        this.categoricalRadioButton.setSelected(true);
        final JPopupMenu mainPanelPopup = new JPopupMenu();
        mainPanelPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingColorMapPanel.this.populatePopup(mainPanelPopup, actions, expertMode);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                mainPanelPopup.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.mainPanel.setComponentPopupMenu(mainPanelPopup);
        this.dropDownButton.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingColorMapPanel.this.populatePopup(SwingColorMapPanel.this.dropDownButton.getPopupMenu(), actions, expertMode);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingColorMapPanel.this.dropDownButton.getPopupMenu().removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public void populatePopup(JPopupMenu popupMenu, Action[] actions, boolean expertMode) {
        if (actions != null) {
            for (Action action : actions) {
                popupMenu.add(action);
            }
            popupMenu.add(new JSeparator());
        }
        JTable legend = this.categoricalRadioButton.isSelected() ? this.categoricalColorMapEditor.getLegend() : (this.customRadioButton.isSelected() ? this.customColorMapEditor.getLegend() : this.predefinedColorMapEditor.getLegend());
        CopyAction copyAction = new CopyAction("Copy Graphics", null);
        copyAction.setComponent(legend);
        popupMenu.add(copyAction);
        try {
            ExportComponentAction exportComponentAction = new ExportComponentAction("Export Graphics...", null, expertMode);
            exportComponentAction.setComponent(legend);
            popupMenu.add(exportComponentAction);
        }
        catch (NoClassDefFoundError action) {
            // empty catch block
        }
        PrintComponentAction printComponentAction = new PrintComponentAction("Print...", null);
        printComponentAction.setComponent(legend);
        popupMenu.add(printComponentAction);
    }

    protected void updateColorMap() {
        if (this.model != null) {
            Object field = this.model.getColorSelection().getSelected();
            if (field != null && this.model.getType(field) != null) {
                Class type = this.model.getType(field);
                this.categoricalColorMapEditor.setColorMap((MutableColorMap<Color>)this.model.getCategoricalColorMap(field), type);
                CPFormat format = this.model.getFormat(field);
                if (format == null) {
                    if (TypeUtils.isNumericType((Class)type)) {
                        format = null;
                    } else if (TypeUtils.isTemporalType((Class)type)) {
                        format = SwingFormatFactory.getInstance().createDateFormat();
                    }
                }
                this.customColorMapEditor.setColorMap((MutableColorMap<Color>)this.model.getCustomColorMap(field), type, this.model.getNumericMin(field), this.model.getNumericMax(field), format);
                this.predefinedColorMapEditor.setColorMap(this.model.getPredefinedColorMap(field), this.model.getNumericMin(field), this.model.getNumericMax(field), format);
                if (this.categoricalRadioButton.isSelected()) {
                    MutableColorMap colorMap = this.model.getCategoricalColorMap(field);
                    this.setColorMap(colorMap);
                    this.model.setCurrentColorMap(field, colorMap);
                } else if (this.customRadioButton.isSelected()) {
                    MutableColorMap colorMap = this.model.getCustomColorMap(field);
                    this.setColorMap(colorMap);
                    this.model.setCurrentColorMap(field, colorMap);
                } else {
                    MutableColorMap colorMap = this.model.getPredefinedColorMap(field);
                    this.setColorMap(colorMap);
                    this.model.setCurrentColorMap(field, colorMap);
                }
            } else {
                this.setColorMap(null);
            }
        }
    }

    public void saveColorMap(OutputStream os) {
        Element root;
        if (this.categoricalRadioButton.isSelected()) {
            root = ColorMapState.saveCategoricalColorMap(this.colorMap);
        } else if (this.customRadioButton.isSelected()) {
            Number min = this.model.getNumericMin(this.model.getColorSelection().getSelected());
            Number max = this.model.getNumericMax(this.model.getColorSelection().getSelected());
            root = ColorMapState.saveCustomColorMap(min, max, this.colorMap);
        } else {
            root = ColorMapState.savePredefinedColorMap(this.colorMap);
        }
        Document doc = new Document(root);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            Serializer serializer = new Serializer((OutputStream)bos, "UTF-8");
            serializer.setIndent(4);
            serializer.write(doc);
            bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void loadColorMap(InputStream is) {
        try {
            Builder builder = new Builder(false);
            BufferedInputStream bis = new BufferedInputStream(is);
            Document treemap = builder.build((InputStream)bis);
            Element root = treemap.getRootElement();
            if (root.getLocalName().equals("Colormap")) {
                String type = root.getAttributeValue("type");
                if ("predefined".equals(type)) {
                    ColorMapState.loadPredefined(root, this.model.getPredefinedColorMap(this.model.getColorSelection().getSelected()));
                    this.predefinedRadioButton.setSelected(true);
                } else if ("custom".equals(type)) {
                    Number min = this.model.getNumericMin(this.model.getColorSelection().getSelected());
                    Number max = this.model.getNumericMax(this.model.getColorSelection().getSelected());
                    ColorMapState.loadCustom(min, max, root, this.model.getCustomColorMap(this.model.getColorSelection().getSelected()));
                    this.customRadioButton.setSelected(true);
                } else if ("categorical".equals(type)) {
                    ColorMapState.loadCategorical(this.model.getType(this.model.getColorSelection().getSelected()), root, this.model.getCategoricalColorMap(this.model.getColorSelection().getSelected()));
                    this.categoricalRadioButton.setSelected(true);
                }
            }
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JPanel getNativeComponent() {
        return this.mainPanel;
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public ColorMapPanelModel<C, Color> getModel() {
        return this.model;
    }

    public void setType(ColorMapPanel.Type type) {
        switch (type) {
            case Categorical: {
                this.categoricalRadioButton.setSelected(true);
                break;
            }
            case Predefined: {
                this.predefinedRadioButton.setSelected(true);
                break;
            }
            case Custom: {
                this.customRadioButton.setSelected(true);
            }
        }
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.dropDownButton = new SimpleDropDownButton();
        this.categoricalRadioButton = new MJRadioButton();
        this.predefinedRadioButton = new MJRadioButton();
        this.customRadioButton = new MJRadioButton();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel1.setOpaque(false);
        this.mainPanel.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BorderLayout(0, 0));
        this.editorPanel.setOpaque(false);
        panel1.add((Component)this.editorPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.typeButtonPanel = new JPanel();
        this.typeButtonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1));
        this.typeButtonPanel.setOpaque(false);
        panel1.add((Component)this.typeButtonPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, new Dimension(0, -1), null, null, 0, false));
        this.categoricalRadioButton.setIconTextGap(1);
        this.categoricalRadioButton.setInheritsPopupMenu(true);
        this.categoricalRadioButton.setText("Categorical");
        this.categoricalRadioButton.setVisible(true);
        this.typeButtonPanel.add((Component)this.categoricalRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 5, 0, new Dimension(0, -1), null, null, 0, false));
        this.customRadioButton.setIconTextGap(1);
        this.customRadioButton.setInheritsPopupMenu(true);
        this.customRadioButton.setText("Custom");
        this.typeButtonPanel.add((Component)this.customRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 5, 0, new Dimension(0, -1), null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.typeButtonPanel.add((Component)spacer1, new GridConstraints(0, 3, 1, 1, 0, 1, 5, 1, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.predefinedRadioButton.setIconTextGap(1);
        this.predefinedRadioButton.setInheritsPopupMenu(true);
        this.predefinedRadioButton.setText("Predefined");
        this.typeButtonPanel.add((Component)this.predefinedRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, new Dimension(0, -1), null, null, 0, false));
        this.dropDownButton = new SimpleDropDownButton();
        this.typeButtonPanel.add((Component)this.dropDownButton, new GridConstraints(0, 4, 1, 1, 4, 0, 0, 3, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.categoricalRadioButton);
        buttonGroup.add(this.customRadioButton);
        buttonGroup.add(this.predefinedRadioButton);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

