/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.drawing.axis;

import com.macrofocus.color.ColorModel;
import com.macrofocus.drawing.axis.AxisModel;
import com.macrofocus.drawing.axis.AxisRenderer;
import com.macrofocus.drawing.axis.AxisView;
import com.macrofocus.drawing.coordinate.CoordinateSystemModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class VerticalAxisRenderer
implements AxisRenderer {
    private AxisModel axisModel;
    private AxisView axisView;
    private PropertiesModel propertiesModel;
    private Color rangeTrapezoidColor;

    public VerticalAxisRenderer(AxisModel axisModel, final AxisView axisView, final PropertiesModel propertiesModel) {
        this.axisModel = axisModel;
        this.axisView = axisView;
        this.propertiesModel = propertiesModel;
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    VerticalAxisRenderer.this.updateProperties(propertiesModel);
                    axisView.repaint();
                }
            });
        }
    }

    @Override
    public void drawAxis(Graphics g, int alignment, boolean drawRangeTrapezoid, double fullRangeMin, double fullRangeMax, int marginLow, int marginHigh) {
        Dimension d = this.axisView.getSize();
        if (drawRangeTrapezoid) {
            CoordinateSystemModel coordinateSystem = this.axisModel.getCoordinateSystemModel();
            int[] x = new int[4];
            int[] y = new int[4];
            x[0] = 0;
            y[0] = 0;
            x[1] = 0;
            y[1] = d.height - 1;
            x[2] = d.width - 1;
            y[2] = (int)((coordinateSystem.getWorldMinY() - fullRangeMin) / (fullRangeMax - fullRangeMin) * (double)(d.height - marginHigh - marginLow));
            y[2] = y[2] + marginLow;
            y[2] = d.height - y[2];
            x[3] = d.width - 1;
            y[3] = (int)((coordinateSystem.getWorldMaxY() - fullRangeMin) / (fullRangeMax - fullRangeMin) * (double)(d.height - marginHigh - marginLow));
            y[3] = y[3] + marginLow;
            y[3] = d.height - y[3];
            if (alignment == 4) {
                for (int i = 0; i < 4; ++i) {
                    x[i] = d.width - 1 - x[i];
                }
            }
            g.setColor(this.rangeTrapezoidColor);
            g.fillPolygon(x, y, 4);
        }
        g.setColor(Color.black);
        int x = alignment == 3 ? 0 : d.width - 1;
        g.drawLine(x, 0, x, d.height - 1);
    }

    @Override
    public void drawTickMarks(Graphics g, int alignment) {
        int x2;
        int x1;
        CoordinateSystemModel coordinateSystem = this.axisModel.getCoordinateSystemModel();
        double[] values = this.axisModel.getTickValues();
        g.setColor(Color.black);
        int tick_length = 5;
        Dimension d = this.axisView.getSize();
        if (alignment == 3) {
            x1 = 0;
            x2 = tick_length - 1;
        } else {
            x1 = d.width - tick_length;
            x2 = d.width - 1;
        }
        for (int i = 0; i < values.length; ++i) {
            int y = coordinateSystem.yWorldToScreen(values[i]);
            g.drawLine(x1, y, x2, y);
        }
    }

    @Override
    public void drawTickLabels(Graphics g, int alignment) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        DecimalFormat df = (DecimalFormat)nf;
        double[] values = this.axisModel.getTickValues();
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > this.axisView.getLargestLabelValue())) continue;
            int max_label_length = df.format(this.axisView.getLargestLabelValue()).length();
            int num_fraction_digits = max_label_length - 4;
            if (num_fraction_digits > 0) {
                char[] c = new char[num_fraction_digits];
                for (int j = 0; j < c.length; ++j) {
                    c[j] = 35;
                }
                String pattern = "0." + String.copyValueOf(c) + "E0";
                df.applyPattern(pattern);
                break;
            }
            df.applyPattern("0E0");
            break;
        }
        String[] labels = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            labels[i] = df.format(values[i]);
        }
        CoordinateSystemModel coordinateSystem = this.axisModel.getCoordinateSystemModel();
        int arbitrary_beautification_correction_to_line_up_minus_sign_with_tick = 2;
        int label_shift = g.getFontMetrics().getAscent() / 2 - arbitrary_beautification_correction_to_line_up_minus_sign_with_tick;
        g.setColor(Color.black);
        for (int i = 0; i < values.length; ++i) {
            int x = this.getLabelXPosition(alignment, g, labels, i);
            int y = coordinateSystem.yWorldToScreen(values[i]) + label_shift;
            g.drawString(labels[i], x, y);
        }
    }

    @Override
    public void drawTickLabelsAndMarks(Graphics g, int alignment) {
        int available_space;
        int number_of_labels_that_fit;
        int label_y;
        int tick_y;
        int label_x;
        int tick_x2_short;
        int tick_x1_short;
        int tick_x2;
        int tick_x1;
        int num_fraction_digits;
        int max_label_length = this.axisView.getMaxLabelWidth();
        String pattern_template = "#########################################################";
        double[] values = this.axisModel.getTickValues();
        int max_integer_length = 1;
        int max_exponent = 0;
        for (int i = 0; i < values.length; ++i) {
            int exponent;
            int integer_length = String.valueOf((int)Math.abs(values[i])).length();
            if (integer_length > max_integer_length) {
                max_integer_length = integer_length;
            }
            if (Math.abs(exponent = this.extractExponent(values[i])) <= Math.abs(max_exponent)) continue;
            max_exponent = exponent;
        }
        Object pattern = max_exponent >= 0 && max_integer_length + 1 > max_label_length || max_exponent < 0 && -max_exponent + 3 > max_label_length ? ((num_fraction_digits = max_label_length - 4) > 0 ? "0." + pattern_template.substring(0, num_fraction_digits) + "E0" : "0E0") : ((num_fraction_digits = max_label_length - max_integer_length - 2) > 0 ? "0." + pattern_template.substring(0, num_fraction_digits) : "0");
        NumberFormat nf = NumberFormat.getNumberInstance();
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern((String)pattern);
        CoordinateSystemModel coordinateSystem = this.axisModel.getCoordinateSystemModel();
        String[] labels = new String[values.length];
        int[] tick_y_screen_position = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            labels[i] = df.format(values[i]);
            tick_y_screen_position[i] = coordinateSystem.yWorldToScreen(values[i]);
        }
        int arbitrary_beautification_correction_to_line_up_minus_sign_with_tick = 2;
        int height_returned_by_system = g.getFontMetrics().getAscent();
        int label_shift = height_returned_by_system / 2 - arbitrary_beautification_correction_to_line_up_minus_sign_with_tick;
        int label_height = height_returned_by_system - 2 * arbitrary_beautification_correction_to_line_up_minus_sign_with_tick;
        if (label_height < 0) {
            label_height = 0;
            label_shift = 0;
        }
        Dimension d = this.axisView.getSize();
        int tick_length = 5;
        int tick_length_short = 2;
        if (alignment == 3) {
            tick_x1 = 0;
            tick_x2 = tick_length - 1;
            tick_x1_short = 0;
            tick_x2_short = tick_length_short - 1;
        } else {
            tick_x1 = d.width - tick_length;
            tick_x2 = d.width - 1;
            tick_x1_short = d.width - tick_length_short;
            tick_x2_short = d.width - 1;
        }
        g.setColor(Color.black);
        int top_of_first_label = label_height;
        if (labels.length > 0) {
            label_x = this.getLabelXPosition(alignment, g, labels, 0);
            tick_y = tick_y_screen_position[0];
            label_y = tick_y + label_shift;
            if (label_y > d.height - 1) {
                label_y = d.height - 1;
            }
            g.drawString(labels[0], label_x, label_y);
            g.drawLine(tick_x1, tick_y, tick_x2, tick_y);
            top_of_first_label = label_y - (label_height - 1);
        }
        int bottom_of_last_label = 0;
        if (labels.length > 0) {
            label_x = this.getLabelXPosition(alignment, g, labels, labels.length - 1);
            tick_y = tick_y_screen_position[values.length - 1];
            label_y = tick_y + label_shift;
            if (label_y - label_height < 0) {
                label_y = label_height;
            }
            bottom_of_last_label = label_y;
            g.drawString(labels[labels.length - 1], label_x, label_y);
            g.drawLine(tick_x1, tick_y, tick_x2, tick_y);
        }
        if ((number_of_labels_that_fit = (available_space = top_of_first_label - bottom_of_last_label + 1) / (label_height + 2)) > 0) {
            int interval = (int)Math.ceil((double)(labels.length - 2) / (double)number_of_labels_that_fit);
            if (interval < 1) {
                interval = 1;
            }
            for (int i = interval; i < values.length - 1; i += interval) {
                label_x = this.getLabelXPosition(alignment, g, labels, i);
                tick_y = tick_y_screen_position[i];
                label_y = tick_y + label_shift;
                if (label_y >= top_of_first_label - 1 || label_y - (label_height - 1) <= bottom_of_last_label + 1) continue;
                g.drawString(labels[i], label_x, label_y);
                g.drawLine(tick_x1, tick_y, tick_x2, tick_y);
            }
        }
        for (int i = 1; i < values.length - 1; ++i) {
            tick_y = tick_y_screen_position[i];
            g.drawLine(tick_x1_short, tick_y, tick_x2_short, tick_y);
        }
    }

    private int extractExponent(double value) {
        double _LOG10SCALE = 1.0 / Math.log(10.0);
        int exponent = (int)Math.floor(Math.log(Math.abs(value)) * _LOG10SCALE);
        return exponent;
    }

    private int getLabelXPosition(int alignment, Graphics g, String[] labels, int labelIndex) {
        int x;
        int label_spacing = 10;
        Dimension d = this.axisView.getSize();
        if (alignment == 3) {
            x = label_spacing;
        } else {
            int width = g.getFontMetrics().stringWidth(labels[labelIndex]);
            x = d.width - 1 - label_spacing - width;
        }
        return x;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        if (propertiesModel != null) {
            this.rangeTrapezoidColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "rangeTrapezoidColor")).getColor();
        }
    }
}

