/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.layer;

import com.macrofocus.layer.ContainerLayerView;
import com.macrofocus.layer.LayerHelper;
import com.macrofocus.layer.LayerView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ComponentLayerView
extends Component
implements LayerView {
    private boolean isFullRepaint = false;
    private Insets insets = new Insets(0, 0, 0, 0);

    @Override
    public String getName() {
        Object name = super.getName();
        if (name == null) {
            name = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        }
        return name;
    }

    @Override
    public Object getFullName() {
        return LayerHelper.getFullName(this);
    }

    @Override
    public LayerView getParentLayerView() {
        return LayerHelper.getParentLayerView(this);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public void update(Graphics g) {
        LayerHelper.update(this, g);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void repaintImmediately() {
        Rectangle bounds = this.getBounds();
        ((ContainerLayerView)this.getParent()).repaintImmediately(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.inside(x, y);
    }

    @Override
    public boolean inside(int x, int y) {
        Dimension d = this.getSize();
        return x >= 0 && x < d.width && y >= 0 && y < d.height;
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    @Override
    public Component getComponentAt(int x, int y) {
        return this.locate(x, y);
    }

    @Override
    public Component locate(int x, int y) {
        return this.contains(x, y) ? this : null;
    }

    @Override
    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    public void setFullRepaint(Object source, boolean value) {
        this.isFullRepaint = value;
    }

    public boolean isFullRepaint() {
        return this.isFullRepaint;
    }

    public void paint() {
    }

    public void incrementalPaint() {
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag != this.isVisible()) {
            super.setVisible(aFlag);
            Container parent = this.getParent();
            if (parent != null) {
                Rectangle r = this.getBounds();
                parent.repaint(r.x, r.y, r.width, r.height);
            }
            this.invalidate();
        }
    }
}

