/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.adapter;

import com.macrofocus.slider.single.SingleSliderEvent;
import com.macrofocus.slider.single.SingleSliderListener;
import com.macrofocus.slider.single.SingleSliderModel;
import com.macrofocus.util.range.MBoundedRangeEvent;
import com.macrofocus.util.range.MBoundedRangeListener;
import com.macrofocus.util.range.MBoundedRangeModel;
import java.util.ArrayList;
import java.util.List;

public class MBoundedRangeSingleSliderAdapter
implements SingleSliderModel {
    private MBoundedRangeModel boundedRangeModel;
    private List<SingleSliderListener> sliderListeners;
    private MBoundedRangeListener listener = new MBoundedRangeListener(){

        public void boundedRangeChanged(MBoundedRangeEvent event) {
            MBoundedRangeSingleSliderAdapter.this.notifySliderChanged(new SingleSliderEvent());
        }
    };

    public MBoundedRangeSingleSliderAdapter(MBoundedRangeModel boundedRangeModel) {
        this.boundedRangeModel = boundedRangeModel;
        this.boundedRangeModel.addBoundedRangeListener(this.listener);
        this.sliderListeners = new ArrayList<SingleSliderListener>();
    }

    @Override
    public double getValue() {
        return this.boundedRangeModel.getValue();
    }

    @Override
    public double getExtent() {
        return this.boundedRangeModel.getExtent();
    }

    @Override
    public void setValue(double value) {
        this.boundedRangeModel.setValue((Object)this, value);
    }

    @Override
    public double getMinimum() {
        return this.boundedRangeModel.getMinimum();
    }

    @Override
    public double getMaximum() {
        return this.boundedRangeModel.getMaximum();
    }

    @Override
    public void setMinMax(double min, double max) {
        this.boundedRangeModel.setMinMax((Object)this, min, max);
    }

    public void setMinimum(Object source, double min) {
        this.boundedRangeModel.setMinimum(source, min);
    }

    public void setMaximum(Object source, double max) {
        this.boundedRangeModel.setMaximum(source, max);
    }

    @Override
    public void addSliderListener(SingleSliderListener rangeSliderListener) {
        this.sliderListeners.add(rangeSliderListener);
    }

    @Override
    public void removeSliderListener(SingleSliderListener rangeSliderListener) {
        this.sliderListeners.remove(rangeSliderListener);
    }

    private void notifySliderChanged(SingleSliderEvent event) {
        for (SingleSliderListener sliderListener : this.sliderListeners) {
            sliderListener.sliderChanged(event);
        }
    }

    public void dispose() {
        this.boundedRangeModel.removeBoundedRangeListener(this.listener);
    }
}

