/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.awt;

import java.awt.Color;
import java.awt.Graphics;

public class DrawingTools {
    public static final void draw3DRect(int x, int y, int width, int height, boolean raised, Graphics g, Color base_color) {
        Color light_color = base_color.brighter();
        Color dark_color = base_color.darker();
        if (width < 4 || height < 4) {
            if (raised) {
                g.setColor(light_color);
            } else {
                g.setColor(dark_color);
            }
            g.fillRect(x, y, width, height);
            return;
        }
        if (raised) {
            g.setColor(light_color);
            g.drawLine(x, y, x + width - 2, y);
            g.drawLine(x, y, x, y + height - 2);
            g.setColor(dark_color);
            g.drawLine(x + 1, y + height - 2, x + width - 2, y + height - 2);
            g.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 2);
            g.setColor(Color.black);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        } else {
            g.setColor(Color.black);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(dark_color);
            g.drawLine(x + 1, y + 1, x + width - 2, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + height - 2);
            g.setColor(light_color);
            g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
            g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        }
    }

    public static final void fillThin3DRect(int x, int y, int width, int height, boolean raised, Graphics g, Color base_color) {
        g.setColor(base_color);
        g.fillRect(x, y, width, height);
        DrawingTools.drawThin3DRect(x, y, width, height, raised, g, base_color);
    }

    public static final void drawThin3DRect(int x, int y, int width, int height, boolean raised, Graphics g, Color base_color) {
        Color light_color = base_color.brighter();
        Color dark_color = base_color.darker();
        if (width < 4 || height < 4) {
            if (raised) {
                g.setColor(light_color);
            } else {
                g.setColor(dark_color);
            }
            g.fillRect(x, y, width, height);
            return;
        }
        if (raised) {
            g.setColor(light_color);
            g.drawLine(x, y, x + width - 2, y);
            g.drawLine(x, y + 1, x, y + height - 2);
            g.setColor(dark_color);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        } else {
            g.setColor(dark_color);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(light_color);
            g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
            g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        }
    }

    public static final void drawFrame(int x, int y, int width, int height, Graphics g, Color frame_color) {
        g.setColor(frame_color);
        g.drawLine(x, y, x + width - 2, y);
        g.drawLine(x, y, x, y + height - 2);
        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
    }
}

