/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.util.geometry.LayersModel;
import com.macrofocus.util.geometry.PointModel;
import com.macrofocus.util.geometry.TriangleModel;
import java.awt.Color;

public class Delaunay {
    PointModel firstP;
    PointModel lastP;
    boolean allCollinear = true;
    TriangleModel firstT;
    TriangleModel lastT;
    public TriangleModel startTriangle;
    TriangleModel startTriangleHull;
    int nPoints = 0;
    protected LayersModel canvas;
    Color color = Color.black;
    protected boolean showDel;
    protected boolean showVor;
    protected boolean showHull;

    public Delaunay() {
        this.canvas = new LayersModel(1);
    }

    public void createLayers(int layers) {
        this.canvas = new LayersModel(layers);
    }

    public LayersModel getLayersModel() {
        return this.canvas;
    }

    public void showDelaunay(boolean st) {
        this.showDel = st;
    }

    public boolean showDelaunayState() {
        return this.showDel;
    }

    public void showVoronoi(boolean st) {
        this.showVor = st;
    }

    public boolean showVoronoiState() {
        return this.showVor;
    }

    public void showConvex(boolean st) {
        this.showHull = st;
    }

    public boolean showConvexState() {
        return this.showHull;
    }

    public void insertPoint(PointModel p) {
        TriangleModel t = this.insertPointSimple(p);
        if (t == null) {
            return;
        }
        TriangleModel tt = t;
        do {
            this.flip(tt);
        } while ((tt = tt.getCanext()) != t && !tt.isHalfplane());
        this.canvas.add(p, 0);
    }

    private TriangleModel insertPointSimple(PointModel p) {
        ++this.nPoints;
        if (!this.allCollinear) {
            TriangleModel t = this.startTriangle.find(p);
            this.startTriangle = t.isHalfplane() ? this.extendOutside(t, p) : this.extendInside(t, p);
            return this.startTriangle;
        }
        if (this.nPoints == 1) {
            this.firstP = p;
            return null;
        }
        if (this.nPoints == 2) {
            this.startTriangulation(this.firstP, p);
            return null;
        }
        switch (p.pointLineTest(this.firstP, this.lastP)) {
            case 1: {
                this.startTriangle = this.extendOutside(this.firstT.getAbnext(), p);
                this.allCollinear = false;
                break;
            }
            case 2: {
                this.startTriangle = this.extendOutside(this.firstT, p);
                this.allCollinear = false;
                break;
            }
            case 0: {
                this.insertCollinear(p, 0);
                break;
            }
            case 3: {
                this.insertCollinear(p, 3);
                break;
            }
            case 4: {
                this.insertCollinear(p, 4);
            }
        }
        return null;
    }

    private void insertCollinear(PointModel p, int res) {
        switch (res) {
            case 3: {
                TriangleModel t = new TriangleModel(this.firstP, p);
                TriangleModel tp = new TriangleModel(p, this.firstP);
                t.setNextTriangleAb(tp);
                tp.setNextTriangleAb(t);
                t.setNextTriangleBc(tp);
                tp.setNextTriangleCa(t);
                t.setNextTriangleCa(this.firstT);
                this.firstT.setNextTriangleBc(t);
                tp.setNextTriangleBc(this.firstT.getAbnext());
                this.firstT.getAbnext().setNextTriangleCa(tp);
                this.firstT = t;
                this.firstP = p;
                break;
            }
            case 4: {
                TriangleModel t = new TriangleModel(p, this.lastP);
                TriangleModel tp = new TriangleModel(this.lastP, p);
                t.setNextTriangleAb(tp);
                tp.setNextTriangleAb(t);
                t.setNextTriangleBc(this.lastT);
                this.lastT.setNextTriangleCa(t);
                t.setNextTriangleCa(tp);
                tp.setNextTriangleBc(t);
                tp.setNextTriangleCa(this.lastT.getAbnext());
                this.lastT.getAbnext().setNextTriangleBc(tp);
                this.lastT = t;
                this.lastP = p;
                break;
            }
            case 0: {
                TriangleModel u = this.firstT;
                while (p.isGreater(u.getA())) {
                    u = u.getCanext();
                }
                TriangleModel t = new TriangleModel(p, u.getB());
                TriangleModel tp = new TriangleModel(u.getB(), p);
                u.setPointB(p);
                u.getAbnext().setPointA(p);
                t.setNextTriangleAb(tp);
                tp.setNextTriangleAb(t);
                t.setNextTriangleBc(u.getBcnext());
                u.getBcnext().setNextTriangleCa(t);
                t.setNextTriangleCa(u);
                u.setNextTriangleBc(t);
                tp.setNextTriangleCa(u.getAbnext().getCanext());
                u.getAbnext().getCanext().setNextTriangleBc(tp);
                tp.setNextTriangleBc(u.getAbnext());
                u.getAbnext().setNextTriangleCa(tp);
                if (this.firstT != u) break;
                this.firstT = t;
            }
        }
    }

    private void startTriangulation(PointModel p1, PointModel p2) {
        PointModel pb;
        PointModel ps;
        if (p1.isLess(p2)) {
            ps = p1;
            pb = p2;
        } else {
            ps = p2;
            pb = p1;
        }
        this.lastT = this.firstT = new TriangleModel(pb, ps);
        TriangleModel t = new TriangleModel(ps, pb);
        this.firstT.setNextTriangleAb(t);
        t.setNextTriangleAb(this.firstT);
        this.firstT.setNextTriangleBc(t);
        t.setNextTriangleCa(this.firstT);
        this.firstT.setNextTriangleCa(t);
        t.setNextTriangleBc(this.firstT);
        this.firstP = this.firstT.getB();
        this.lastP = this.lastT.getA();
        this.startTriangleHull = this.firstT;
    }

    public TriangleModel extendInside(TriangleModel t, PointModel p) {
        TriangleModel h1 = this.treatDegeneracyInside(t, p);
        if (h1 != null) {
            return h1;
        }
        h1 = new TriangleModel(t.getC(), t.getA(), p);
        TriangleModel h2 = new TriangleModel(t.getB(), t.getC(), p);
        t.setPointC(p);
        t.circumcircle();
        h1.setNextTriangleAb(t.getCanext());
        h1.setNextTriangleBc(t);
        h1.setNextTriangleCa(h2);
        h2.setNextTriangleAb(t.getBcnext());
        h2.setNextTriangleBc(h1);
        h2.setNextTriangleCa(t);
        h1.getAbnext().switchneighbors(t, h1);
        h2.getAbnext().switchneighbors(t, h2);
        t.setNextTriangleBc(h2);
        t.setNextTriangleCa(h1);
        return t;
    }

    public TriangleModel treatDegeneracyInside(TriangleModel t, PointModel p) {
        if (t.getAbnext().isHalfplane() && p.pointLineTest(t.getB(), t.getA()) == 0) {
            return this.extendOutside(t.getAbnext(), p);
        }
        if (t.getBcnext().isHalfplane() && p.pointLineTest(t.getC(), t.getB()) == 0) {
            return this.extendOutside(t.getBcnext(), p);
        }
        if (t.getCanext().isHalfplane() && p.pointLineTest(t.getA(), t.getC()) == 0) {
            return this.extendOutside(t.getCanext(), p);
        }
        return null;
    }

    private TriangleModel extendOutside(TriangleModel t, PointModel p) {
        if (p.pointLineTest(t.getA(), t.getB()) == 0) {
            TriangleModel dg = new TriangleModel(t.getA(), t.getB(), p);
            TriangleModel hp = new TriangleModel(p, t.getB());
            t.setPointB(p);
            dg.setNextTriangleAb(t.getAbnext());
            dg.getAbnext().switchneighbors(t, dg);
            dg.setNextTriangleBc(hp);
            hp.setNextTriangleAb(dg);
            dg.setNextTriangleCa(t);
            t.setNextTriangleAb(dg);
            hp.setNextTriangleBc(t.getBcnext());
            hp.getBcnext().setNextTriangleCa(hp);
            hp.setNextTriangleCa(t);
            t.setNextTriangleBc(hp);
            return dg;
        }
        TriangleModel ccT = this.extendcounterclock(t, p);
        TriangleModel cT = this.extendclock(t, p);
        ccT.setNextTriangleBc(cT);
        cT.setNextTriangleCa(ccT);
        this.startTriangleHull = cT;
        return cT.getAbnext();
    }

    private TriangleModel extendcounterclock(TriangleModel t, PointModel p) {
        t.setHalfplane(false);
        t.setPointC(p);
        t.circumcircle();
        TriangleModel tca = t.getCanext();
        if (p.pointLineTest(tca.getA(), tca.getB()) >= 2) {
            TriangleModel nT = new TriangleModel(t.getA(), p);
            nT.setNextTriangleAb(t);
            t.setNextTriangleCa(nT);
            nT.setNextTriangleCa(tca);
            tca.setNextTriangleBc(nT);
            return nT;
        }
        return this.extendcounterclock(tca, p);
    }

    private TriangleModel extendclock(TriangleModel t, PointModel p) {
        t.setHalfplane(false);
        t.setPointC(p);
        t.circumcircle();
        TriangleModel tbc = t.getBcnext();
        if (p.pointLineTest(tbc.getA(), tbc.getB()) >= 2) {
            TriangleModel nT = new TriangleModel(p, t.getB());
            nT.setNextTriangleAb(t);
            t.setNextTriangleBc(nT);
            nT.setNextTriangleBc(tbc);
            tbc.setNextTriangleCa(nT);
            return nT;
        }
        return this.extendclock(tbc, p);
    }

    public void flip(TriangleModel t) {
        TriangleModel v;
        TriangleModel u = t.getAbnext();
        if (u.isHalfplane() || !u.circumcircle_contains(t.getC())) {
            return;
        }
        if (t.getA() == u.getA()) {
            v = new TriangleModel(u.getB(), t.getB(), t.getC());
            v.setNextTriangleAb(u.getBcnext());
            t.setNextTriangleAb(u.getAbnext());
        } else if (t.getA() == u.getB()) {
            v = new TriangleModel(u.getC(), t.getB(), t.getC());
            v.setNextTriangleAb(u.getCanext());
            t.setNextTriangleAb(u.getBcnext());
        } else if (t.getA() == u.getC()) {
            v = new TriangleModel(u.getA(), t.getB(), t.getC());
            v.setNextTriangleAb(u.getAbnext());
            t.setNextTriangleAb(u.getCanext());
        } else {
            System.out.println("Error in flip.");
            return;
        }
        v.setNextTriangleBc(t.getBcnext());
        v.getAbnext().switchneighbors(u, v);
        v.getBcnext().switchneighbors(t, v);
        t.setNextTriangleBc(v);
        v.setNextTriangleCa(t);
        t.setPointB(v.getA());
        t.getAbnext().switchneighbors(u, t);
        t.circumcircle();
        this.flip(t);
        this.flip(v);
    }

    public void recompute() {
        this.nPoints = 0;
        this.allCollinear = true;
    }
}

