/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.util.geometry.PointModel;
import com.macrofocus.util.geometry.SegmentModel;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class VoronoiPointModel {
    PointModel pointModel;
    Vector segments;
    PointModel[] pointModels;

    public VoronoiPointModel(String string) {
        StringTokenizer st = new StringTokenizer(string, ";");
        this.pointModels = new PointModel[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String point = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(point, ",");
            double x = Double.parseDouble(st2.nextToken());
            double y = Double.parseDouble(st2.nextToken());
            this.pointModels[i] = new PointModel(x, y);
            ++i;
        }
    }

    public VoronoiPointModel(PointModel pointModel) {
        this.pointModel = pointModel;
        this.segments = new Vector();
    }

    public void addSegmentModel(SegmentModel segmentModel) {
        this.segments.addElement(segmentModel);
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    public SegmentModel getSegment(int index) {
        return (SegmentModel)this.segments.elementAt(index);
    }

    public int getPointCount() {
        return this.pointModels.length;
    }

    public PointModel getPoint(int index) {
        return this.pointModels[index];
    }

    public void pack() {
        final PointModel referencePointModel = this.pointModel;
        TreeSet<PointModel> treeSet = new TreeSet<PointModel>(new Comparator(){

            public int compare(Object o1, Object o2) {
                double t2;
                PointModel p1 = (PointModel)o1;
                PointModel p2 = (PointModel)o2;
                if (p1.equals(p2)) {
                    return 0;
                }
                double t1 = VoronoiPointModel.theta(referencePointModel, p1);
                if (t1 >= (t2 = VoronoiPointModel.theta(referencePointModel, p2))) {
                    return 1;
                }
                return -1;
            }
        });
        for (int i = 0; i < this.getSegmentCount(); ++i) {
            treeSet.add(this.getSegment((int)i).a);
            treeSet.add(this.getSegment((int)i).b);
        }
        Object[] obj = treeSet.toArray();
        this.pointModels = new PointModel[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            this.pointModels[i] = (PointModel)obj[i];
        }
    }

    public void packTest() {
        HashMap<PointModel, PointModel> treeMap = new HashMap<PointModel, PointModel>();
        for (int i = 0; i < this.getSegmentCount(); ++i) {
            if (treeMap.containsKey(this.getSegment((int)i).a)) {
                treeMap.put(this.getSegment((int)i).b, this.getSegment((int)i).a);
            } else {
                treeMap.put(this.getSegment((int)i).a, this.getSegment((int)i).b);
            }
            if (treeMap.containsKey(this.getSegment((int)i).b)) continue;
            treeMap.put(this.getSegment((int)i).b, this.getSegment((int)i).a);
        }
        this.pointModels = new PointModel[treeMap.keySet().size()];
        PointModel current = this.getSegment((int)0).a;
        for (int i = 0; i < this.pointModels.length; ++i) {
            PointModel next;
            this.pointModels[i] = current;
            current = next = (PointModel)treeMap.get(current);
        }
    }

    public void packNew() {
        HashMap<PointModel, PointModel> treeMap = new HashMap<PointModel, PointModel>();
        for (int i = 0; i < this.getSegmentCount(); ++i) {
            if (!treeMap.containsKey(this.getSegment((int)i).a)) {
                PointModel[] p2 = new PointModel[2];
                p2[0] = this.getSegment((int)i).b;
                treeMap.put(this.getSegment((int)i).a, this.getSegment((int)i).b);
            }
            if (treeMap.containsKey(this.getSegment((int)i).b)) continue;
            treeMap.put(this.getSegment((int)i).b, this.getSegment((int)i).a);
        }
        this.pointModels = new PointModel[treeMap.keySet().size()];
        PointModel first = this.getSegment((int)0).a;
        PointModel second = this.getSegment((int)0).a;
        for (int i = 0; i < this.pointModels.length; ++i) {
            for (int j = 0; j < this.getSegmentCount(); ++j) {
                this.pointModels[i] = first;
            }
        }
    }

    public void packxxx() {
        int i;
        HashMap<PointModel, PointModel> treeMap = new HashMap<PointModel, PointModel>();
        for (i = 0; i < this.getSegmentCount(); ++i) {
            if (treeMap.containsKey(this.getSegment((int)i).a)) {
                treeMap.put(this.getSegment((int)i).b, this.getSegment((int)i).a);
                continue;
            }
            treeMap.put(this.getSegment((int)i).a, this.getSegment((int)i).b);
        }
        for (i = 0; i < this.getSegmentCount(); ++i) {
            if (treeMap.containsKey(this.getSegment((int)i).b)) continue;
            treeMap.put(this.getSegment((int)i).b, this.getSegment((int)i).a);
        }
        PointModel start = this.getSegment((int)0).a;
        PointModel end = this.getSegment((int)0).b;
        LinkedList<PointModel> linkedList = new LinkedList<PointModel>();
        linkedList.addFirst(start);
        linkedList.addLast(end);
        this.pointModels = new PointModel[treeMap.keySet().size()];
    }

    public void packnew() {
        int i;
        HashMap<PointModel, PointModel> treeMap = new HashMap<PointModel, PointModel>();
        for (i = 0; i < this.getSegmentCount(); ++i) {
            if (treeMap.containsKey(this.getSegment((int)i).a)) {
                treeMap.put(this.getSegment((int)i).b, this.getSegment((int)i).a);
                continue;
            }
            treeMap.put(this.getSegment((int)i).a, this.getSegment((int)i).b);
        }
        for (i = 0; i < this.getSegmentCount(); ++i) {
            if (treeMap.containsKey(this.getSegment((int)i).b)) continue;
            treeMap.put(this.getSegment((int)i).b, this.getSegment((int)i).a);
        }
        this.pointModels = new PointModel[treeMap.keySet().size()];
        PointModel start = this.getSegment((int)0).a;
        PointModel end = this.getSegment((int)0).b;
        int startIndex = 0;
        int endIndex = this.pointModels.length - 1;
        this.pointModels[startIndex] = start;
        this.pointModels[endIndex] = end;
        boolean count = false;
        boolean found = false;
        do {
            for (int i2 = 1; i2 < this.getSegmentCount(); ++i2) {
                if (!this.getSegment((int)i2).a.equals(start)) continue;
            }
        } while (found);
    }

    public String toString() {
        Object str = "";
        for (int i = 0; i < this.getPointCount(); ++i) {
            PointModel p = this.getPoint(i);
            if (i > 0) {
                str = (String)str + ";";
            }
            str = (String)str + p.x + "," + p.y;
        }
        return str;
    }

    private static double theta(PointModel p1, PointModel p2) {
        double dy;
        double ay;
        double dx = p2.x - p1.x;
        double ax = Math.abs(dx);
        double t = ax + (ay = Math.abs(dy = p2.y - p1.y)) == 0.0 ? 0.0 : Math.atan2(dx, dy);
        return t;
    }

    private static double theta2(PointModel p1, PointModel p2) {
        double dy;
        double ay;
        double t;
        double dx = p2.x - p1.x;
        double ax = Math.abs(dx);
        double d = t = ax + (ay = Math.abs(dy = p2.y - p1.y)) == 0.0 ? 0.0 : dy / (ax + ay);
        if (dx < 0.0) {
            t = 2.0 - t;
        } else if (dy < 0.0) {
            t = 4.0 + t;
        }
        return t * 90.0;
    }
}

