/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.java2d;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.java2d.RenderingHintsModel;
import com.macrofocus.util.swing.action.ToggleAction;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class AntialiasingToggleAction
extends ToggleAction {
    private boolean forGraphics = true;
    private boolean forText = true;
    private RenderingHintsModel renderingHintsModel;

    public AntialiasingToggleAction(RenderingHintsModel renderingHintsModel, final PropertiesModel propertiesModel) {
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    AntialiasingToggleAction.this.updateProperties(propertiesModel);
                }
            });
        }
        this.renderingHintsModel = renderingHintsModel;
        this.checkSelected();
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(118, 0));
        this.putValue("MnemonicKey", 65);
    }

    private void checkSelected() {
        boolean selected = false;
        RenderingHints renderingHints = this.renderingHintsModel.getRenderingHints();
        if (this.forGraphics && renderingHints.containsKey(RenderingHints.KEY_ANTIALIASING) && renderingHints.get(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON)) {
            selected = true;
        }
        if (this.forText && renderingHints.containsKey(RenderingHints.KEY_TEXT_ANTIALIASING) && renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING).equals(RenderingHints.VALUE_TEXT_ANTIALIAS_ON)) {
            selected = true;
        }
        this.setSelected(selected);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        super.actionPerformed(ev);
        if (this.isSelected()) {
            if (this.forGraphics) {
                this.renderingHintsModel.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.forText) {
                this.renderingHintsModel.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        } else {
            if (this.forGraphics) {
                this.renderingHintsModel.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            if (this.forText) {
                this.renderingHintsModel.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
    }

    public void setForGraphics(boolean forGraphics) {
        this.forGraphics = forGraphics;
        this.checkSelected();
    }

    public void setForText(boolean forText) {
        this.forText = forText;
        this.checkSelected();
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Antialiasing";
        if (propertiesModel != null && propertiesModel.isAvailable("action.antialiasing.label")) {
            name = (String)propertiesModel.getValue("action.antialiasing.label");
        }
        this.putValue("Name", name);
    }
}

