/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class AbstractComponentDecorator {
    public static final Rectangle DEFAULT_BOUNDS = null;
    public static final int TOP = 0;
    private static final int BOTTOM = -1;
    private Point originOffset = new Point(0, 0);
    private Painter painter;
    private JComponent component;
    private Container parent;
    private Component layerRoot;
    private Listener listener;
    private int layerOffset;
    private int position;
    private Rectangle bounds;
    private static Field nComponents;

    public AbstractComponentDecorator(JComponent c) {
        this(c, 1);
    }

    public AbstractComponentDecorator(JComponent c, int layerOffset) {
        this(c, layerOffset, 0);
    }

    public AbstractComponentDecorator(JComponent c, int layerOffset, int position) {
        this.component = c;
        this.layerOffset = layerOffset;
        this.position = position;
        this.bounds = DEFAULT_BOUNDS;
        this.parent = c.getParent();
        this.painter = new Painter();
        this.listener = new Listener();
        this.component.addHierarchyListener(this.listener);
        this.component.addComponentListener(this.listener);
        this.attach();
    }

    public void setToolTipText(String text) {
        this.painter.setToolTipText(text);
    }

    public String getToolTipText() {
        return this.painter.getToolTipText();
    }

    public String getToolTipText(MouseEvent e) {
        return this.getToolTipText();
    }

    public boolean isVisible() {
        return this.painter.isVisible();
    }

    public void setVisible(boolean visible) {
        this.painter.setVisible(visible);
    }

    protected void attach() {
        RootPaneContainer rpc;
        if (this.layerRoot != null) {
            this.layerRoot.removePropertyChangeListener(this.listener);
            this.layerRoot = null;
        }
        if ((rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this.component))) != null && SwingUtilities.isDescendingFrom(this.component, rpc.getLayeredPane())) {
            JLayeredPane lp = rpc.getLayeredPane();
            Container layeredChild = this.component;
            int layer = JLayeredPane.DRAG_LAYER;
            if (this instanceof BackgroundPainter) {
                layer = ((BackgroundPainter)this).layer;
                this.painter.setDecoratedLayer(layer);
            } else if (layeredChild == lp) {
                this.painter.setDecoratedLayer(layer);
            } else {
                BackgroundPainter bp;
                while (layeredChild.getParent() != lp) {
                    layeredChild = layeredChild.getParent();
                }
                int base = lp.getLayer(layeredChild);
                layer = base + this.layerOffset;
                if (this.layerOffset < 0 && (bp = (BackgroundPainter)lp.getClientProperty(BackgroundPainter.key(base))) == null) {
                    bp = new BackgroundPainter(lp, base);
                }
                this.painter.setDecoratedLayer(base);
                this.layerRoot = layeredChild;
                this.layerRoot.addPropertyChangeListener(this.listener);
            }
            lp.add(this.painter, layer, this.position);
        } else {
            Container parent = this.painter.getParent();
            if (parent != null) {
                parent.remove(this.painter);
            }
        }
        if (this.parent != null) {
            this.parent.removeComponentListener(this.listener);
        }
        this.parent = this.component.getParent();
        if (this.parent != null) {
            this.parent.addComponentListener(this.listener);
        }
        this.synch();
    }

    protected void synch() {
        Container painterParent = this.painter.getParent();
        if (painterParent != null) {
            Rectangle decorated = this.getDecorationBounds();
            Rectangle clipRect = this.clipDecorationBounds(decorated);
            Point pt = SwingUtilities.convertPoint(this.component, clipRect.x, clipRect.y, painterParent);
            if (clipRect.width <= 0 || clipRect.height <= 0) {
                this.setPainterBounds(-1, -1, 0, 0);
                this.setVisible(false);
            } else {
                this.setPainterBounds(pt.x, pt.y, clipRect.width, clipRect.height);
                this.setVisible(true);
            }
            painterParent.repaint();
        }
    }

    protected Rectangle clipDecorationBounds(Rectangle decorated) {
        this.originOffset.x = decorated.x;
        this.originOffset.y = decorated.y;
        Rectangle visible = this.getClippingRect(this.component, decorated);
        Rectangle clipRect = decorated.intersection(visible);
        if (decorated.x < visible.x) {
            this.originOffset.x += visible.x - decorated.x;
        }
        if (decorated.y < visible.y) {
            this.originOffset.y += visible.y - decorated.y;
        }
        return clipRect;
    }

    private Rectangle getClippingRect(Container component, Rectangle desired) {
        Rectangle visible = component instanceof JComponent ? ((JComponent)component).getVisibleRect() : new Rectangle(0, 0, component.getWidth(), component.getHeight());
        Rectangle clip = new Rectangle(desired);
        if (!(desired.x >= visible.x && desired.y >= visible.y && desired.x + desired.width <= visible.x + visible.width && desired.y + desired.height <= visible.y + visible.height || component.getParent() == null || component == this.painter.getParent() || visible.x <= 0 && visible.y <= 0 && visible.width >= component.getWidth() && visible.height >= component.getHeight())) {
            desired = new Rectangle(desired);
            desired.x = Math.max(desired.x, visible.x);
            desired.y = Math.max(desired.y, visible.y);
            desired.width = Math.min(desired.width, visible.x + visible.width - desired.x);
            desired.height = Math.min(desired.height, visible.y + visible.height - desired.y);
            desired.x += component.getX();
            desired.y += component.getY();
            clip = this.getClippingRect(component.getParent(), desired);
            clip.x -= component.getX();
            clip.y -= component.getY();
        }
        return clip;
    }

    protected Rectangle getDecorationBounds() {
        return this.bounds != DEFAULT_BOUNDS ? this.bounds : new Rectangle(0, 0, this.component.getWidth(), this.component.getHeight());
    }

    public void setDecorationBounds(Rectangle bounds) {
        this.bounds = bounds == DEFAULT_BOUNDS ? bounds : new Rectangle(bounds);
        this.synch();
    }

    public void setDecorationBounds(int x, int y, int w, int h) {
        this.setDecorationBounds(new Rectangle(x, y, w, h));
    }

    protected void setPainterBounds(int x, int y, int w, int h) {
        this.painter.setLocation(x, y);
        this.painter.setSize(w, h);
        this.repaint();
    }

    protected JComponent getComponent() {
        return this.component;
    }

    protected JComponent getPainter() {
        return this.painter;
    }

    public void setCursor(Cursor cursor) {
        this.painter.setCursor(cursor);
    }

    public void repaint() {
        JLayeredPane p = (JLayeredPane)this.painter.getParent();
        if (p != null) {
            p.repaint(this.painter.getBounds());
        }
    }

    public void dispose() {
        Container painterParent;
        this.component.removeHierarchyListener(this.listener);
        this.component.removeComponentListener(this.listener);
        if (this.parent != null) {
            this.parent.removeComponentListener(this.listener);
            this.parent = null;
        }
        if (this.layerRoot != null) {
            this.layerRoot.removePropertyChangeListener(this.listener);
            this.layerRoot = null;
        }
        if ((painterParent = this.painter.getParent()) != null) {
            Rectangle bounds = this.painter.getBounds();
            painterParent.remove(this.painter);
            painterParent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        this.component.repaint();
        this.component = null;
    }

    public abstract void paint(Graphics var1);

    public String toString() {
        return super.toString() + " on " + String.valueOf(this.getComponent());
    }

    private static boolean useSimpleBackground() {
        return nComponents == null;
    }

    static {
        try {
            nComponents = Container.class.getDeclaredField("ncomponents");
            nComponents.setAccessible(true);
        }
        catch (Exception e) {
            nComponents = null;
        }
    }

    private class Painter
    extends JComponent {
        private int base;
        private Cursor cursor;

        private Painter() {
            this.setFocusable(false);
        }

        public JComponent getComponent() {
            return AbstractComponentDecorator.this.getComponent();
        }

        public void setDecoratedLayer(int base) {
            this.base = base;
        }

        public int getDecoratedLayer() {
            return this.base;
        }

        public boolean isBackgroundDecoration() {
            return AbstractComponentDecorator.this.layerOffset < 0;
        }

        @Override
        public void setCursor(Cursor cursor) {
            Cursor oldCursor = this.getCursor();
            if (oldCursor == null && cursor != null || oldCursor != null && !oldCursor.equals(cursor)) {
                this.cursor = cursor;
                super.setCursor(cursor);
            }
        }

        @Override
        public Cursor getCursor() {
            return this.cursor != null ? this.cursor : AbstractComponentDecorator.this.component.getCursor();
        }

        @Override
        public void paintComponent(Graphics g) {
            if (!AbstractComponentDecorator.this.component.isShowing()) {
                return;
            }
            Graphics g2 = g.create();
            g2.translate(-AbstractComponentDecorator.this.originOffset.x, -AbstractComponentDecorator.this.originOffset.y);
            AbstractComponentDecorator.this.paint(g2);
            g2.dispose();
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            return AbstractComponentDecorator.this.getToolTipText(e);
        }

        @Override
        public String toString() {
            return "Painter for " + String.valueOf(AbstractComponentDecorator.this);
        }
    }

    private final class Listener
    extends ComponentAdapter
    implements HierarchyListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) != 0L) {
                AbstractComponentDecorator.this.attach();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("layeredContainerLayer".equals(e.getPropertyName())) {
                AbstractComponentDecorator.this.attach();
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            AbstractComponentDecorator.this.attach();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            AbstractComponentDecorator.this.attach();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            AbstractComponentDecorator.this.setVisible(false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            AbstractComponentDecorator.this.setVisible(true);
        }
    }

    private static class BackgroundPainter
    extends AbstractComponentDecorator {
        private String key;
        private int layer;

        private static String key(int layer) {
            return "backgroundPainter for layer " + layer;
        }

        public BackgroundPainter(JLayeredPane p, int layer) {
            super(p, 0, 0);
            this.layer = layer;
            this.key = BackgroundPainter.key(layer);
            p.putClientProperty(this.key, this);
        }

        private int hideChildren(Container c) {
            if (c == null) {
                return 0;
            }
            int value = c.getComponentCount();
            try {
                nComponents.set(c, 0);
            }
            catch (Exception e) {
                return c.getComponentCount();
            }
            return value;
        }

        private void restoreChildren(Container c, int count) {
            if (c != null) {
                try {
                    nComponents.set(c, count);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void paintBackground(Graphics g, Component parent, JComponent jc) {
            int x = jc.getX();
            int y = jc.getY();
            int w = jc.getWidth();
            int h = jc.getHeight();
            this.paintBackground(g.create(x, y, w, h), jc);
        }

        private void paintBackground(Graphics g, JComponent jc) {
            if (jc.isOpaque()) {
                if (AbstractComponentDecorator.useSimpleBackground()) {
                    g.setColor(jc.getBackground());
                    g.fillRect(0, 0, jc.getWidth(), jc.getHeight());
                } else {
                    int count = this.hideChildren(jc);
                    boolean db = jc.isDoubleBuffered();
                    if (db) {
                        jc.setDoubleBuffered(false);
                    }
                    jc.paint(g);
                    if (db) {
                        jc.setDoubleBuffered(true);
                    }
                    this.restoreChildren(jc, count);
                }
            }
            Component[] kids = jc.getComponents();
            for (int i = 0; i < kids.length; ++i) {
                if (!(kids[i] instanceof JComponent)) continue;
                this.paintBackground(g, jc, (JComponent)kids[i]);
            }
        }

        private List findOpaque(Component root) {
            ArrayList<Component> list = new ArrayList<Component>();
            if (root.isOpaque() && root instanceof JComponent) {
                list.add(root);
                ((JComponent)root).setOpaque(false);
            }
            if (root instanceof Container) {
                Component[] kids = ((Container)root).getComponents();
                for (int i = 0; i < kids.length; ++i) {
                    list.addAll(this.findOpaque(kids[i]));
                }
            }
            return list;
        }

        private List findDoubleBuffered(Component root) {
            ArrayList<Component> list = new ArrayList<Component>();
            if (root.isDoubleBuffered() && root instanceof JComponent) {
                list.add(root);
                ((JComponent)root).setDoubleBuffered(false);
            }
            if (root instanceof Container) {
                Component[] kids = ((Container)root).getComponents();
                for (int i = 0; i < kids.length; ++i) {
                    list.addAll(this.findDoubleBuffered(kids[i]));
                }
            }
            return list;
        }

        private void paintForeground(Graphics g, JComponent jc) {
            List opaque = this.findOpaque(jc);
            List db = this.findDoubleBuffered(jc);
            jc.paint(g);
            Iterator i = opaque.iterator();
            while (i.hasNext()) {
                ((JComponent)i.next()).setOpaque(true);
            }
            i = db.iterator();
            while (i.hasNext()) {
                ((JComponent)i.next()).setDoubleBuffered(true);
            }
        }

        @Override
        public void paint(Graphics g) {
            JLayeredPane lp = (JLayeredPane)this.getComponent();
            Component[] kids = lp.getComponents();
            Area area = new Area();
            ArrayList<Painter> painters = new ArrayList<Painter>();
            ArrayList<Component> components = new ArrayList<Component>();
            for (int i = kids.length - 1; i >= 0; --i) {
                if (kids[i] instanceof Painter) {
                    Painter painter = (Painter)kids[i];
                    if (!painter.isBackgroundDecoration() || painter.getDecoratedLayer() != this.layer || !painter.isShowing()) continue;
                    painters.add(painter);
                    area.add(new Area(painter.getBounds()));
                    continue;
                }
                if (lp.getLayer(kids[i]) != this.layer || !(kids[i] instanceof JComponent)) continue;
                components.add(kids[i]);
            }
            if (painters.size() == 0) {
                this.dispose();
                return;
            }
            g.setClip(area);
            for (JComponent jComponent : components) {
                this.paintBackground(g, lp, jComponent);
            }
            for (Painter painter : painters) {
                painter.paint(g.create(painter.getX(), painter.getY(), painter.getWidth(), painter.getHeight()));
            }
            for (JComponent jComponent : components) {
                this.paintForeground(g.create(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight()), jComponent);
            }
        }

        @Override
        public void dispose() {
            this.getComponent().putClientProperty(this.key, null);
            super.dispose();
        }

        @Override
        public String toString() {
            return this.key + " on " + String.valueOf(this.getComponent());
        }
    }
}

