/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf;

import com.incors.plaf.ColorUIResource2;
import com.incors.plaf.kunststoff.GradientTheme;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalTheme;

public class MacrofocusLightKunststoffMetalTheme
extends MetalTheme
implements GradientTheme {
    private final ColorUIResource background = new ColorUIResource(0, 0, 127);
    private final ColorUIResource primary1 = new ColorUIResource(32, 32, 42);
    private final ColorUIResource primary2 = new ColorUIResource(160, 160, 190);
    private final ColorUIResource primary3 = new ColorUIResource(200, 200, 234);
    private final ColorUIResource secondary1 = new ColorUIResource(130, 130, 140);
    private final ColorUIResource secondary2 = new ColorUIResource(180, 180, 190);
    private final ColorUIResource secondary3 = new ColorUIResource(224, 224, 234);
    private FontUIResource menuFont;
    private FontUIResource windowTitleFont;
    private FontUIResource monospacedFont;
    private final ColorUIResource componentGradientColorReflection = new ColorUIResource2(245, 245, 255, 96);
    private final ColorUIResource componentGradientColorShadow = new ColorUIResource2(0, 0, 10, 48);
    private final ColorUIResource textComponentGradientColorReflection = new ColorUIResource2(0, 0, 10, 32);
    private final ColorUIResource textComponentGradientColorShadow = null;
    private static final int backgroundGradientShadow = 32;
    private final ColorUIResource primary0 = new ColorUIResource(51, 51, 102);
    private final ColorUIResource secondary0 = new ColorUIResource(0, 0, 0);
    private final ColorUIResource secondary4 = new ColorUIResource(255, 255, 255);
    private FontUIResource controlFont;
    private FontUIResource systemFont;
    private FontUIResource userFont;
    private FontUIResource smallFont;

    @Override
    public String getName() {
        return "Macrofocus";
    }

    public MacrofocusLightKunststoffMetalTheme() {
        URL collapsed = this.getClass().getResource("collapsed.gif");
        URL expanded = this.getClass().getResource("expanded.gif");
        if (collapsed != null && expanded != null) {
            ImageIcon collapsedIcon = new ImageIcon(collapsed);
            ImageIcon expandedIcon = new ImageIcon(expanded);
            UIManager.put("Tree.expandedIcon", expandedIcon);
            UIManager.put("Tree.collapsedIcon", collapsedIcon);
        }
        UIManager.put("List.selectionBackground", new Color(255, 220, 220));
        UIManager.put("Tree.selectionBackground", new Color(255, 220, 220));
        UIManager.put("Table.selectionBackground", new Color(255, 220, 220));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = graphicsEnvironment.getAvailableFontFamilyNames();
        HashSet<String> hashset = new HashSet<String>(Arrays.asList(fontFamilies));
        if (hashset.contains("Arial")) {
            this.menuFont = new FontUIResource("Arial", 1, 12);
            this.controlFont = new FontUIResource("Arial", 1, 11);
            this.systemFont = new FontUIResource("Arial", 0, 11);
            this.userFont = new FontUIResource("Arial", 0, 11);
            this.smallFont = new FontUIResource("Arial", 0, 9);
            this.windowTitleFont = new FontUIResource("Arial", 1, 12);
        } else if (hashset.contains("Helvetica")) {
            this.menuFont = new FontUIResource("Helvetica", 1, 12);
            this.controlFont = new FontUIResource("Helvetica", 1, 11);
            this.systemFont = new FontUIResource("Helvetica", 0, 11);
            this.userFont = new FontUIResource("Helvetica", 0, 11);
            this.smallFont = new FontUIResource("Helvetica", 0, 9);
            this.windowTitleFont = new FontUIResource("Helvetica", 1, 12);
        }
    }

    ColorUIResource getPrimary0() {
        return this.primary0;
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    ColorUIResource getSecondary0() {
        return this.secondary0;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    ColorUIResource getSecondary4() {
        return this.secondary4;
    }

    @Override
    public FontUIResource getControlTextFont() {
        if (this.controlFont == null) {
            try {
                this.controlFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Dialog", 1, 12)));
            }
            catch (Exception e) {
                this.controlFont = new FontUIResource("Dialog", 1, 12);
            }
        }
        return this.controlFont;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        if (this.systemFont == null) {
            try {
                this.systemFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.systemFont", new Font("Dialog", 0, 12)));
            }
            catch (Exception e) {
                this.systemFont = new FontUIResource("Dialog", 0, 12);
            }
        }
        return this.systemFont;
    }

    @Override
    public FontUIResource getUserTextFont() {
        if (this.userFont == null) {
            try {
                this.userFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.userFont", new Font("Dialog", 0, 12)));
            }
            catch (Exception e) {
                this.userFont = new FontUIResource("Dialog", 0, 12);
            }
        }
        return this.userFont;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        if (this.menuFont == null) {
            try {
                this.menuFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Dialog", 1, 12)));
            }
            catch (Exception e) {
                this.menuFont = new FontUIResource("Dialog", 1, 12);
            }
        }
        return this.menuFont;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        if (this.windowTitleFont == null) {
            try {
                this.windowTitleFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Dialog", 1, 12)));
            }
            catch (Exception e) {
                this.windowTitleFont = new FontUIResource("Dialog", 1, 12);
            }
        }
        return this.windowTitleFont;
    }

    @Override
    public FontUIResource getSubTextFont() {
        if (this.smallFont == null) {
            try {
                this.smallFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.smallFont", new Font("Dialog", 0, 10)));
            }
            catch (Exception e) {
                this.smallFont = new FontUIResource("Dialog", 0, 10);
            }
        }
        return this.smallFont;
    }

    private Font getPrivilegedFont(final String property, final Font defaultFont) {
        return (Font)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Font.getFont(property, defaultFont);
            }
        });
    }

    public ColorUIResource getComponentGradientColorReflection() {
        return this.componentGradientColorReflection;
    }

    public ColorUIResource getComponentGradientColorShadow() {
        return this.componentGradientColorShadow;
    }

    public ColorUIResource getTextComponentGradientColorReflection() {
        return this.textComponentGradientColorReflection;
    }

    public ColorUIResource getTextComponentGradientColorShadow() {
        return this.textComponentGradientColorShadow;
    }

    public int getBackgroundGradientShadow() {
        return 32;
    }
}

