/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.print;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DefaultContentProvider;
import com.macrofocus.util.swing.print.JComponentPrintable;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;

public class PrintComponentAction
extends AbstractAction {
    private ContentProvider<Component> component;
    private String propertyKey;
    private final MutableProperty<PageFormat> pageFormat;

    public PrintComponentAction() {
        this((ResourcesModel)null, null);
    }

    public PrintComponentAction(MutableProperty<PageFormat> pageFormat) {
        this(null, null, pageFormat);
    }

    public PrintComponentAction(String name, Component component) {
        super(name);
        this.component = new DefaultContentProvider<Component>(component);
        this.pageFormat = new SimpleProperty(null);
        this.checkEnabled();
    }

    public PrintComponentAction(ResourcesModel resourcesModel, String propertyKey) {
        this(resourcesModel, propertyKey, (MutableProperty<PageFormat>)new SimpleProperty(null));
    }

    public PrintComponentAction(ResourcesModel resourcesModel, String propertyKey, MutableProperty<PageFormat> pageFormat) {
        super("Print...");
        this.propertyKey = propertyKey;
        this.pageFormat = pageFormat;
        if (resourcesModel != null) {
            URL url = resourcesModel.getUrl("Print16.gif");
            if (url != null) {
                this.putValue("SmallIcon", new ImageIcon(url));
            }
            final PropertiesModel propertiesModel = resourcesModel.getPropertiesModel();
            this.updateProperties(propertiesModel);
            if (propertiesModel != null) {
                propertiesModel.addPropertiesListener(new PropertiesListener(){

                    public void propertiesChanged(PropertiesEvent e) {
                        PrintComponentAction.this.updateProperties(propertiesModel);
                    }
                });
            }
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("MnemonicKey", 80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.component == null) return;
        PrinterJob job = PrinterJob.getPrinterJob();
        if (this.pageFormat.getValue() == null) {
            PageFormat defaultPf = job.defaultPage();
            defaultPf.setOrientation(0);
            this.pageFormat.setValue((Object)defaultPf);
        }
        if (this.component instanceof JTable) {
            try {
                job.setPrintable(this.getPrintable((JTable)((Object)this.component)), (PageFormat)this.pageFormat.getValue());
                boolean printAccepted = job.printDialog();
                if (!printAccepted) return;
                job.print();
                return;
            }
            catch (PrinterException e1) {
                e1.printStackTrace();
            }
            return;
        }
        try {
            PrintComponentAction.disableDoubleBuffering(this.component.getContent());
            job.setPrintable(this.getPrintable(), (PageFormat)this.pageFormat.getValue());
            boolean printAccepted = job.printDialog();
            if (!printAccepted) return;
            job.print();
            return;
        }
        catch (PrinterException e) {
            Logging.getInstance().process((Throwable)e);
            return;
        }
        finally {
            PrintComponentAction.enableDoubleBuffering(this.component.getContent());
        }
    }

    private JComponentPrintable getPrintable() {
        return new JComponentPrintable(this.component.getContent(), true);
    }

    public void setComponent(Component component) {
        this.component = new DefaultContentProvider<Component>(component);
        this.setEnabled(component != null);
    }

    public void setComponent(ContentProvider<Component> component) {
        this.component = component;
    }

    private void checkEnabled() {
        boolean enable = this.component != null;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPrintJobAccess();
            }
            this.setEnabled(enable);
        }
        catch (Exception e) {
            this.setEnabled(false);
        }
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Print...";
        if (propertiesModel != null && propertiesModel.isAvailable(this.propertyKey)) {
            name = String.valueOf(propertiesModel.getValue(this.propertyKey)) + "...";
        }
        this.putValue("Name", name);
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public Printable getPrintable(JTable table) {
        Printable printable = table.getPrintable(JTable.PrintMode.FIT_WIDTH, null, new MessageFormat("Page - {0}"));
        return printable;
    }
}

