/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.table;

import com.macrofocus.util.swing.table.ColorTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public final class ColorTableCellEditor
extends ColorTableCellRenderer
implements TableCellEditor {
    private final JColorChooser colorChooser;
    private final JDialog colorDialog;
    private final EventListenerList listenerList = new EventListenerList();
    private final ChangeEvent event = new ChangeEvent(this);
    protected int clickCountToStart = 1;

    public ColorTableCellEditor(Component parentComponent) {
        this.colorChooser = new JColorChooser();
        this.colorDialog = JColorChooser.createDialog(null, "Color", false, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ColorTableCellEditor.this.fireEditingStopped();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ColorTableCellEditor.this.fireEditingCanceled();
            }
        });
        this.colorDialog.setLocationRelativeTo(parentComponent);
    }

    @Override
    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Color) {
            this.colorChooser.setColor((Color)value);
        }
        return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
    }

    @Override
    public final boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public final boolean shouldSelectCell(EventObject anEvent) {
        this.colorDialog.setVisible(true);
        return true;
    }

    @Override
    public final void cancelCellEditing() {
        this.colorDialog.setVisible(false);
    }

    @Override
    public final boolean stopCellEditing() {
        this.colorDialog.setVisible(false);
        return true;
    }

    @Override
    public final Object getCellEditorValue() {
        return this.colorChooser.getColor();
    }

    @Override
    public final void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public final void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    private void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.event);
        }
    }

    private void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.event);
        }
    }

    public void setClickCountToStart(int clickCountToStart) {
        this.clickCountToStart = clickCountToStart;
    }
}

