/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.table;

import com.macrofocus.data.type.series.NumericalSeries;
import com.macrofocus.data.type.series.Series;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.coordinate.OptimizedCoordinateAxisModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class SeriesView
extends JPanel {
    private Series series;
    private CoordinateAxisModel xCoordinateAxis = new OptimizedCoordinateAxisModel(0.0, 1.0);
    private CoordinateAxisModel yCoordinateAxis = new OptimizedCoordinateAxisModel(0.0, 1.0);

    public SeriesView() {
        this.yCoordinateAxis.setWorldCoordinatesInverted(true);
    }

    public void setSeries(Series series) {
        this.series = series;
        if (series != null) {
            this.xCoordinateAxis.setWorldMin(0.0);
            this.xCoordinateAxis.setWorldMax(series.getItemCount());
            if (series instanceof NumericalSeries) {
                NumericalSeries numericalSeries = (NumericalSeries)series;
                Number minValue = numericalSeries.getMinValue();
                Number maxValue = numericalSeries.getMaxValue();
                if (minValue != null && maxValue != null) {
                    this.yCoordinateAxis.setWorldMin(minValue.doubleValue());
                    this.yCoordinateAxis.setWorldMax(maxValue.doubleValue());
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.series != null) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            this.xCoordinateAxis.setScreenSize(d.width);
            this.yCoordinateAxis.setScreenSize(d.height);
            GeneralPath markerPath = new GeneralPath();
            RangePoint previous = null;
            if (this.series instanceof NumericalSeries) {
                NumericalSeries numericalTimeSeries = (NumericalSeries)this.series;
                GeneralPath linePath = new GeneralPath();
                for (int i = 0; i < this.series.getItemCount(); ++i) {
                    int x = this.xCoordinateAxis.worldToScreen(i);
                    int y = this.yCoordinateAxis.worldToScreen(((Number)numericalTimeSeries.getValue(i)).doubleValue());
                    if (previous != null) {
                        if (x != previous.x) {
                            if (previous.yMin != previous.yMax) {
                                linePath.lineTo(previous.x, previous.yMin);
                                linePath.lineTo(previous.x, previous.yMax);
                                linePath.lineTo(previous.x, previous.y);
                            }
                            linePath.lineTo(x, y);
                        }
                        previous.setValue(x, y);
                        continue;
                    }
                    previous = new RangePoint();
                    previous.setValue(x, y);
                    linePath.moveTo(x, y);
                    linePath.lineTo(x, y);
                }
                g2.setColor(Color.darkGray);
                g2.draw(linePath);
            } else {
                for (int i = 0; i < this.series.getItemCount(); ++i) {
                    int x = this.xCoordinateAxis.worldToScreen(i);
                    int y = d.height / 2;
                    int size = 4;
                    float halfSize = 2.0f;
                    Rectangle2D.Float shape = new Rectangle2D.Float((float)x - 2.0f, (float)y - 2.0f, 4.0f, 4.0f);
                    markerPath.append(shape, false);
                }
            }
            g2.setColor(Color.darkGray);
            g2.draw(markerPath);
        }
    }

    private class RangePoint {
        public int x;
        public int y;
        public int yMin;
        public int yMax;

        private RangePoint() {
        }

        void setValue(int x, int y) {
            if (this.x == x) {
                if (y < this.yMin) {
                    this.yMin = y;
                }
                if (y > this.yMax) {
                    this.yMax = y;
                }
                this.y = y;
            } else {
                this.x = x;
                this.y = y;
                this.yMin = y;
                this.yMax = y;
            }
        }
    }
}

