/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.wizard;

import com.macrofocus.layer.ContainerLayerView;
import com.macrofocus.layer.EmptyLayerView;
import com.macrofocus.layoutmanager.HorizontalProportionalLayoutManager;
import com.macrofocus.layoutmanager.MinimumProportionalConstraint;
import com.macrofocus.layoutmanager.RelativeProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.macrofocus.util.wizard.WizardEvent;
import com.macrofocus.util.wizard.WizardListener;
import com.macrofocus.util.wizard.WizardModel;
import com.macrofocus.util.wizard.WizardView;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JTabbedPane;

public class TabWizardView
extends WizardView {
    private final WizardModel wizardModel;
    private final Container container;
    private final Container buttonsContainer;
    private final JTabbedPane taskContainer;
    private final JButton nextButton;
    private final JButton previousButton;

    public TabWizardView(final WizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.container = new ContainerLayerView();
        this.buttonsContainer = new ContainerLayerView();
        this.taskContainer = new JTabbedPane();
        this.nextButton = new JButton("Next");
        this.previousButton = new JButton("Previous");
        this.buttonsContainer.setLayout((LayoutManager)new HorizontalProportionalLayoutManager());
        this.buttonsContainer.add((Component)new EmptyLayerView(), new RelativeProportionalConstraint());
        this.buttonsContainer.add((Component)this.previousButton, new MinimumProportionalConstraint());
        this.buttonsContainer.add((Component)this.nextButton, new MinimumProportionalConstraint());
        this.previousButton.setEnabled(wizardModel.isPreviousEnabled());
        this.nextButton.setEnabled(wizardModel.isNextEnabled());
        this.container.setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        this.setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        for (int i = 0; i < wizardModel.getTaskCount(); ++i) {
            this.taskContainer.addTab(wizardModel.getTitle(i), wizardModel.getTask(i));
        }
        this.container.add((Component)this.taskContainer, new RelativeProportionalConstraint());
        this.container.add((Component)this.buttonsContainer, new MinimumProportionalConstraint());
        this.add((Component)this.container, new RelativeProportionalConstraint());
        this.validateTree();
        wizardModel.addWizardListener(new WizardListener(){

            @Override
            public void wizardChanged(WizardEvent wizardEvent) {
                TabWizardView.this.taskContainer.setSelectedComponent(wizardModel.getCurrentTask());
            }

            @Override
            public void wizardStateChanged(WizardEvent wizardEvent) {
                TabWizardView.this.previousButton.setEnabled(wizardModel.isPreviousEnabled());
                TabWizardView.this.nextButton.setEnabled(wizardModel.isNextEnabled());
            }
        });
    }

    @Override
    public JButton getNextButton() {
        return this.nextButton;
    }

    @Override
    public JButton getPreviousButton() {
        return this.previousButton;
    }
}

