/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.resources.properties;

import com.macrofocus.common.properties.AbstractMutableProperty;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.resources.properties.AbstractPropertiesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPropertyPropertiesModel
extends AbstractPropertiesModel {
    private final Map<String, PropertiesMutableProperty> propertyMap = new HashMap<String, PropertiesMutableProperty>();

    @Override
    public <T> MutableProperty<T> getProperty(String key) {
        if (this.propertyMap.containsKey(key)) {
            return (MutableProperty)this.propertyMap.get(key);
        }
        PropertiesMutableProperty property = new PropertiesMutableProperty(key);
        this.propertyMap.put(key, property);
        return property;
    }

    @Override
    protected void notifyPropertiesChanged(PropertiesEvent event) {
        super.notifyPropertiesChanged(event);
        if (this.propertyMap.containsKey(event.getKey())) {
            this.propertyMap.get(event.getKey()).notifyPropertyChanged(new PropertyEvent(event.getPreviousValue(), event.getValue()));
        }
    }

    @Override
    public Object getValue(Class cl, String name, String property, Object defaultValue) {
        if (this.isAvailable(cl, name, property)) {
            return this.getValue(cl, name, property);
        }
        return defaultValue;
    }

    @Override
    public Object getValue(Class cl, String property, Object defaultValue) {
        if (this.isAvailable(cl.getName() + "." + property)) {
            return this.getValue(cl, property);
        }
        return defaultValue;
    }

    private class PropertiesMutableProperty<T>
    extends AbstractMutableProperty<T> {
        private final String key;

        public PropertiesMutableProperty(String key) {
            this.key = key;
        }

        public void setValue(T value) {
            AbstractPropertyPropertiesModel.this.setValue(this.key, value);
        }

        public T getValue() {
            return (T)AbstractPropertyPropertiesModel.this.getValue(this.key);
        }

        public void notifyPropertyChanged(PropertyEvent<T> event) {
            super.notifyPropertyChanged(event);
        }
    }
}

