/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.j2d;

import com.treemap.swing.originalfastvoronoi.VoroCellObject;
import com.treemap.swing.originalfastvoronoi.convexHull.JVertex;
import com.treemap.swing.originalfastvoronoi.j2d.Colors;
import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j2d.PolygonSimple;
import com.treemap.swing.originalfastvoronoi.j2d.Site;
import com.treemap.swing.originalfastvoronoi.j2d.iSite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class ASite
extends JVertex
implements Comparable<Site>,
iSite {
    protected static final double nearlyZero = 1.0E-10;
    protected double weight = 1.0E-10;
    protected double percentage = 1.0E-10;
    protected PolygonSimple polygon;
    public PolygonSimple nonClippedPolyon;
    protected ArrayList<Site> neighbours;
    public VoroCellObject cellObject;
    public Point2D preflowVector = new Point2D();

    private static double projectZ(double x, double y, double weight) {
        return x * x + y * y - weight;
    }

    @Override
    public PolygonSimple getPolygon() {
        return this.polygon;
    }

    @Override
    public String toString() {
        return "(" + this.getX() + "\t," + this.getY() + "," + this.weight + "," + this.percentage + ")+z: " + this.z;
    }

    @Override
    public void setPolygon(PolygonSimple poly) {
        this.polygon = poly;
    }

    @Override
    public void setNeighbours(ArrayList<Site> list) {
        this.neighbours = list;
    }

    @Override
    public ArrayList<Site> getNeighbours() {
        return this.neighbours;
    }

    public ASite(double x, double y) {
        super(x, y, ASite.projectZ(x, y, 1.0E-10));
        this.weight = 1.0E-10;
    }

    public ASite(double x, double y, double weight) {
        super(x, y, ASite.projectZ(x, y, weight));
        this.weight = weight;
    }

    public ASite(double x, double y, double weight, double percentage) {
        super(x, y, ASite.projectZ(x, y, weight));
        this.weight = weight;
        this.percentage = percentage;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
        this.z = ASite.projectZ(this.getX(), this.getY(), weight);
    }

    @Override
    public void setXY(double x, double y) {
        this.x = x;
        this.y = y;
        this.project();
    }

    @Override
    public void setXYW(double x, double y, double weight) {
        this.x = x;
        this.y = y;
        this.weight = weight;
        this.z = ASite.projectZ(x, y, weight);
    }

    private void project() {
        this.z = ASite.projectZ(this.x, this.y, this.weight);
    }

    @Override
    public void setX(double x) {
        this.x = x;
        this.project();
    }

    @Override
    public void setY(double y) {
        this.y = y;
        this.project();
    }

    @Override
    public int compareTo(Site b) {
        if (this.x < b.x) {
            return -1;
        }
        if (this.x > b.x) {
            return 1;
        }
        if (this.x == b.x) {
            if (this.y < b.y) {
                return -1;
            }
            if (this.y > b.y) {
                return 1;
            }
            if (this.y == b.y) {
                return 0;
            }
        }
        return 0;
    }

    public void paint(Graphics2D g) {
        int radius = (int)Math.sqrt(this.getWeight());
        g.fillOval((int)this.getX() - radius, (int)this.getY() - radius, 2 * radius, 2 * radius);
        g.setColor(Colors.circleBorder);
        g.drawOval((int)this.getX() - radius, (int)this.getY() - radius, 2 * radius, 2 * radius);
        g.setColor(Color.yellow);
        int width = 1;
        g.fillRect((int)this.getX() - width, (int)this.getY() - width, 2 * width, 2 * width);
    }

    @Override
    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    @Override
    public double getPercentage() {
        return this.percentage;
    }

    @Override
    public Point2D getPoint() {
        return new Point2D(this.getX(), this.getY());
    }

    public double distance(Site point) {
        double dx = this.x - point.getX();
        double dy = this.y - point.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distanceCircles(Site point) {
        double dx = this.x - point.getX();
        double dy = this.y - point.getY();
        double radius1 = Math.sqrt(this.weight);
        double radius2 = Math.sqrt(point.weight);
        return Math.sqrt(dx * dx + dy * dy) - radius1 - radius2;
    }
}

