/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.smoothing.AbstractSmoothedSegment;
import com.treemap.swing.voronoi.smoothing.CurveLocation;
import com.treemap.swing.voronoi.smoothing.LineSegment;
import com.treemap.swing.voronoi.smoothing.SegmentLocation;
import com.treemap.swing.voronoi.smoothing.SmoothedSegment;
import com.treemap.swing.voronoi.smoothing.Smoother;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.util.Map;

public class SingleSpline
extends AbstractSmoothedSegment {
    private final CubicCurve2D curve;
    private Map<Double, Point2d> samplesCurve;

    public SingleSpline(CubicCurve2D curve, Vertex startVertex, Vertex endVertex, LineSegment lineSegment) {
        super(startVertex, endVertex, lineSegment);
        this.curve = curve;
    }

    @Override
    public void addToGeneralPath(GeneralPath generalPath) {
        generalPath.append(this.curve, true);
    }

    @Override
    public SmoothedSegment reversed() {
        CubicCurve2D reversed = Smoother.newCubicCurve2D(this.curve.getClass());
        reversed.setCurve(this.curve.getP2(), this.curve.getCtrlP2(), this.curve.getCtrlP1(), this.curve.getP1());
        return new SingleSpline(reversed, this.getStartVertex(), this.getEndVertex(), this.getLineSegment());
    }

    private Map<Double, Point2d> getSamplesOfCurve() {
        if (this.samplesCurve == null) {
            this.samplesCurve = Smoother.createSamples(this.curve);
        }
        return this.samplesCurve;
    }

    @Override
    public SegmentLocation getNearestSegmentLocation(Vertex vertex) {
        return Smoother.getNearestCurveLocation(vertex, this.curve, this.getSamplesOfCurve(), this);
    }

    @Override
    public SmoothedSegment getSubSegment(SegmentLocation start, SegmentLocation end) {
        if (!(start instanceof CurveLocation) || !(end instanceof CurveLocation)) {
            return null;
        }
        CurveLocation startCurveLocation = (CurveLocation)start;
        CurveLocation endCurveLocation = (CurveLocation)end;
        CurveLocation closerToP1 = Smoother.getTheOneCloserToP1(startCurveLocation, endCurveLocation, this.curve);
        boolean reversed = closerToP1 != startCurveLocation;
        CurveLocation closerToP2 = reversed ? startCurveLocation : endCurveLocation;
        CubicCurve2D closerToP1toP2 = Smoother.getSubCruveToP2(closerToP1, this.curve);
        CubicCurve2D result = Smoother.getSubCruveFromP1(closerToP2, closerToP1toP2);
        if (reversed) {
            Smoother.reverse(result);
        }
        return new SingleSpline(result, start.getVertex(), end.getVertex(), this.getLineSegment());
    }
}

