/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.list;

import com.macrofocus.high_d.list.AbstractIndexModel;
import com.macrofocus.high_d.list.IndexListener;
import com.macrofocus.molap.dataframe.DataFrame;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

public class EfficientIndexModel
extends AbstractIndexModel<Object> {
    private Object[] keys;
    private Object[] values;
    private List missingValue;
    private List rows;

    public <R, C, V> EfficientIndexModel(DataFrame<R, C, V> dataFrame, C column, Comparator comparator) {
        Object key;
        TreeMap<Object, Vector> hashtable = new TreeMap<Object, Vector>(comparator);
        this.missingValue = new Vector();
        for (int row = 0; row < dataFrame.getRowCount(); ++row) {
            Object rowKey = dataFrame.getRowKey(row);
            if (dataFrame.getValueAt(rowKey, column) != null) {
                key = dataFrame.getValueAt(rowKey, column);
                if (key instanceof Object[]) {
                    Object[] vector = (Object[])key;
                    for (int i = 0; i < vector.length; ++i) {
                        key = vector[i];
                        Vector value = hashtable.containsKey(key) ? (Vector)hashtable.get(key) : new Vector();
                        value.addElement(row);
                        hashtable.put(key, value);
                    }
                    continue;
                }
                Vector value = hashtable.containsKey(key) ? (Vector)hashtable.get(key) : new Vector();
                value.addElement(row);
                hashtable.put(key, value);
                continue;
            }
            this.missingValue.add(row);
        }
        this.keys = new Object[hashtable.size()];
        this.values = new Object[hashtable.size()];
        int index = 0;
        Iterator e = hashtable.keySet().iterator();
        while (e.hasNext()) {
            this.keys[index] = key = e.next();
            this.values[index] = hashtable.get(key);
            ++index;
        }
        this.rows = new Vector(dataFrame.getRowCount());
        for (int row = 0; row < dataFrame.getRowCount(); ++row) {
            this.rows.add(new Vector());
        }
        for (index = 0; index < this.getObjectCount(); ++index) {
            for (int j = 0; j < this.getRowCount(index); ++j) {
                ((Vector)this.rows.get(this.getRow(index, j))).addElement(index);
            }
        }
    }

    @Override
    public Object getObject(int index) {
        return this.keys[index];
    }

    @Override
    public int getObjectCount() {
        return this.keys.length;
    }

    @Override
    public void addObject(Object source, Object object) {
    }

    @Override
    public void replaceObject(Object source, Object oldkey, Object newkey) {
    }

    @Override
    public void removeObject(Object source, int index, Object key) {
    }

    @Override
    public int getRow(int index, int j) {
        return (Integer)((Vector)this.values[index]).elementAt(j);
    }

    @Override
    public int getRowCount(int index) {
        return ((Vector)this.values[index]).size();
    }

    @Override
    public void addRow(Object source, int index, int row) {
    }

    @Override
    public void removeRow(Object source, int index, int row) {
    }

    @Override
    public int getMissing(int j) {
        return (Integer)this.missingValue.get(j);
    }

    @Override
    public int getMissingCount() {
        return this.missingValue.size();
    }

    @Override
    public void addMissing(Object source, int row) {
    }

    @Override
    public void removeMissing(Object source, int row) {
    }

    @Override
    public int getIndex(int row, int j) {
        return (Integer)((Vector)this.rows.get(row)).elementAt(j);
    }

    @Override
    public int getIndexCount(int row) {
        return ((Vector)this.rows.get(row)).size();
    }

    @Override
    public void addIndexListener(IndexListener indexListener) {
    }
}

