/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.blending;

public enum BlendingMode {
    SourceOver{

        @Override
        public void blend(int[] src, int[] dst, int[] result) {
            throw new IllegalArgumentException("Not implemented!");
        }
    }
    ,
    Add{

        @Override
        public void blend(int[] src, int[] dst, int[] result) {
            result[0] = Math.min(255, src[0] + dst[0]);
            result[1] = Math.min(255, src[1] + dst[1]);
            result[2] = Math.min(255, src[2] + dst[2]);
            result[3] = Math.min(255, src[3] + dst[3]);
        }
    }
    ,
    Normal{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0];
            result[1] = src[1];
            result[2] = src[2];
            result[3] = src[3];
        }
    }
    ,
    Darken{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = Math.min(src[0], dst[0]);
            result[1] = Math.min(src[1], dst[1]);
            result[2] = Math.min(src[2], dst[2]);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Multiply{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0] * dst[0] + 2 >> 8;
            result[1] = src[1] * dst[1] + 2 >> 8;
            result[2] = src[2] * dst[2] + 2 >> 8;
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    ColorBurn{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0] == 0 ? 0 : Math.max(0, 255 - (255 - dst[0] << 8) / src[0]);
            result[1] = src[1] == 0 ? 0 : Math.max(0, 255 - (255 - dst[1] << 8) / src[1]);
            result[2] = src[2] == 0 ? 0 : Math.max(0, 255 - (255 - dst[2] << 8) / src[2]);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    LinearBurn{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0] + dst[0] == 0 ? 0 : src[0] + dst[0] - 255;
            result[1] = src[1] + dst[1] == 0 ? 0 : src[1] + dst[1] - 255;
            result[2] = src[2] + dst[2] == 0 ? 0 : src[2] + dst[2] - 255;
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Lighten{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = Math.max(src[0], dst[0]);
            result[1] = Math.max(src[1], dst[1]);
            result[2] = Math.max(src[2], dst[2]);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Screen{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = 255 - ((255 - src[0]) * (255 - dst[0]) >> 8);
            result[1] = 255 - ((255 - src[1]) * (255 - dst[1]) >> 8);
            result[2] = 255 - ((255 - src[2]) * (255 - dst[2]) >> 8);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    ColorDodge{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0] == 255 ? 255 : Math.min((dst[0] << 8) / (255 - src[0]), 255);
            result[1] = src[1] == 255 ? 255 : Math.min((dst[1] << 8) / (255 - src[1]), 255);
            result[2] = src[2] == 255 ? 255 : Math.min((dst[2] << 8) / (255 - src[2]), 255);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    LinearDodge{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = Math.min(255, src[0] + dst[0]);
            result[1] = Math.min(255, src[1] + dst[1]);
            result[2] = Math.min(255, src[2] + dst[2]);
            result[3] = Math.min(255, src[3] + dst[3]);
        }
    }
    ,
    Overlay{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = dst[0] < 128 ? dst[0] * src[0] >> 7 : 255 - ((255 - dst[0]) * (255 - src[0]) >> 7);
            result[1] = dst[1] < 128 ? dst[1] * src[1] >> 7 : 255 - ((255 - dst[1]) * (255 - src[1]) >> 7);
            result[2] = dst[2] < 128 ? dst[2] * src[2] >> 7 : 255 - ((255 - dst[2]) * (255 - src[2]) >> 7);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    SoftLight{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            int mRed = src[0] * dst[0] / 255;
            int mGreen = src[1] * dst[1] / 255;
            int mBlue = src[2] * dst[2] / 255;
            result[0] = mRed + dst[0] * (255 - (255 - dst[0]) * (255 - src[0]) / 255 - mRed) / 255;
            result[1] = mGreen + dst[1] * (255 - (255 - dst[1]) * (255 - src[1]) / 255 - mGreen) / 255;
            result[2] = mBlue + dst[2] * (255 - (255 - dst[2]) * (255 - src[2]) / 255 - mBlue) / 255;
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    HardLight{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0] < 128 ? dst[0] * dst[0] >> 7 : 255 - ((255 - dst[0]) * (255 - src[0]) >> 7);
            result[1] = dst[1] < 128 ? dst[1] * src[1] >> 7 : 255 - ((255 - dst[1]) * (255 - src[1]) >> 7);
            result[2] = dst[2] < 128 ? dst[2] * src[2] >> 7 : 255 - ((255 - dst[2]) * (255 - src[2]) >> 7);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    VividLight{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            int n = src[0] < 128 ? (src[0] == 0 ? 0 : Math.max(0, 255 - (255 - dst[0] << 7) / src[0])) : (result[0] = src[0] == 255 ? 255 : Math.min(255, (dst[0] << 7) / (255 - src[0])));
            int n2 = src[1] < 128 ? (src[1] == 0 ? 0 : Math.max(0, 255 - (255 - dst[1] << 7) / src[1])) : (result[1] = src[1] == 255 ? 255 : Math.min(255, (dst[1] << 7) / (255 - src[1])));
            result[2] = src[2] < 128 ? (src[2] == 0 ? 0 : Math.max(0, 255 - (255 - dst[2] << 7) / src[2])) : (src[2] == 255 ? 255 : Math.min(255, (dst[2] << 7) / (255 - src[2])));
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    LinearLight{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0] < 128 ? Math.max(0, dst[0] + (src[0] << 1) - 255) : Math.min(255, dst[0] + (src[0] - 128 << 1));
            result[1] = src[1] < 128 ? Math.max(0, dst[1] + (src[1] << 1) - 255) : Math.min(255, dst[1] + (src[1] - 128 << 1));
            result[2] = src[2] < 128 ? Math.max(0, dst[2] + (src[2] << 1) - 255) : Math.min(255, dst[2] + (src[2] - 128 << 1));
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    PinLight{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0] < 128 ? Math.min(dst[0], src[0] << 1) : Math.max(dst[0], src[0] - 128 << 1);
            result[1] = src[1] < 128 ? Math.min(dst[1], src[1] << 1) : Math.max(dst[1], src[1] - 128 << 1);
            result[2] = src[2] < 128 ? Math.min(dst[2], src[2] << 1) : Math.max(dst[2], src[2] - 128 << 1);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    HardMix{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = src[0] < 256 - dst[0] ? 0 : 255;
            result[1] = src[1] < 256 - dst[1] ? 0 : 255;
            result[2] = src[2] < 256 - dst[2] ? 0 : 255;
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Difference{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = Math.abs(dst[0] - src[0]);
            result[1] = Math.abs(dst[1] - src[1]);
            result[2] = Math.abs(dst[2] - src[2]);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Substract{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[0] = Math.max(0, src[0] + dst[0] - 256);
            result[1] = Math.max(0, src[1] + dst[1] - 256);
            result[2] = Math.max(0, src[2] + dst[2] - 256);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Divide{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Hue{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            float[] srcHSL = new float[3];
            BlendingMode.RGBtoHSL(src[0], src[1], src[2], srcHSL);
            float[] dstHSL = new float[3];
            BlendingMode.RGBtoHSL(dst[0], dst[1], dst[2], dstHSL);
            BlendingMode.HSLtoRGB(srcHSL[0], dstHSL[1], dstHSL[2], result);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Saturation{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            float[] srcHSL = new float[3];
            BlendingMode.RGBtoHSL(src[0], src[1], src[2], srcHSL);
            float[] dstHSL = new float[3];
            BlendingMode.RGBtoHSL(dst[0], dst[1], dst[2], dstHSL);
            BlendingMode.HSLtoRGB(dstHSL[0], srcHSL[1], dstHSL[2], result);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Color{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            float[] srcHSL = new float[3];
            BlendingMode.RGBtoHSL(src[0], src[1], src[2], srcHSL);
            float[] dstHSL = new float[3];
            BlendingMode.RGBtoHSL(dst[0], dst[1], dst[2], dstHSL);
            BlendingMode.HSLtoRGB(srcHSL[0], srcHSL[1], dstHSL[2], result);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    }
    ,
    Luminosity{

        @Override
        void blend(int[] src, int[] dst, int[] result) {
            float[] srcHSL = new float[3];
            BlendingMode.RGBtoHSL(src[0], src[1], src[2], srcHSL);
            float[] dstHSL = new float[3];
            BlendingMode.RGBtoHSL(dst[0], dst[1], dst[2], dstHSL);
            BlendingMode.HSLtoRGB(dstHSL[0], dstHSL[1], srcHSL[2], result);
            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
        }
    };


    abstract void blend(int[] var1, int[] var2, int[] var3);

    private static float[] RGBtoHSL(int r, int g, int b, float[] hsl) {
        float S;
        float H;
        float var_Max;
        float var_Min;
        if (hsl == null) {
            hsl = new float[3];
        } else if (hsl.length < 3) {
            throw new IllegalArgumentException("hsl array must have a length of at least 3");
        }
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        float var_R = (float)r / 255.0f;
        float var_G = (float)g / 255.0f;
        float var_B = (float)b / 255.0f;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        float del_Max = var_Max - var_Min;
        float L = (var_Max + var_Min) / 2.0f;
        if (del_Max - 0.01f <= 0.0f) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = L < 0.5f ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
            float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
            H = var_R == var_Max ? del_B - del_G : (var_G == var_Max ? 0.33333334f + del_R - del_B : 0.6666667f + del_G - del_R);
            if (H < 0.0f) {
                H += 1.0f;
            }
            if (H > 1.0f) {
                H -= 1.0f;
            }
        }
        hsl[0] = H;
        hsl[1] = S;
        hsl[2] = L;
        return hsl;
    }

    private static int[] HSLtoRGB(float h, float s, float l, int[] rgb) {
        int B;
        int G;
        int R2;
        if (rgb == null) {
            rgb = new int[3];
        } else if (rgb.length < 3) {
            throw new IllegalArgumentException("rgb array must have a length of at least 3");
        }
        if (h < 0.0f) {
            h = 0.0f;
        } else if (h > 1.0f) {
            h = 1.0f;
        }
        if (s < 0.0f) {
            s = 0.0f;
        } else if (s > 1.0f) {
            s = 1.0f;
        }
        if (l < 0.0f) {
            l = 0.0f;
        } else if (l > 1.0f) {
            l = 1.0f;
        }
        if (s - 0.01f <= 0.0f) {
            R2 = (int)(l * 255.0f);
            G = (int)(l * 255.0f);
            B = (int)(l * 255.0f);
        } else {
            float var_2 = l < 0.5f ? l * (1.0f + s) : l + s - s * l;
            float var_1 = 2.0f * l - var_2;
            R2 = (int)(255.0f * BlendingMode.hue2RGB(var_1, var_2, h + 0.33333334f));
            G = (int)(255.0f * BlendingMode.hue2RGB(var_1, var_2, h));
            B = (int)(255.0f * BlendingMode.hue2RGB(var_1, var_2, h - 0.33333334f));
        }
        rgb[0] = R2;
        rgb[1] = G;
        rgb[2] = B;
        return rgb;
    }

    private static float hue2RGB(float v1, float v2, float vH) {
        if (vH < 0.0f) {
            vH += 1.0f;
        }
        if (vH > 1.0f) {
            vH -= 1.0f;
        }
        if (6.0f * vH < 1.0f) {
            return v1 + (v2 - v1) * 6.0f * vH;
        }
        if (2.0f * vH < 1.0f) {
            return v2;
        }
        if (3.0f * vH < 2.0f) {
            return v1 + (v2 - v1) * (0.6666667f - vH) * 6.0f;
        }
        return v1;
    }
}

