/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinatesmatrix;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.hierarchy.DefaultAxisHierarchy;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesSettings;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ParallelCoordinatesMatrixModel;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ParallelCoordinatesMatrixView;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import java.util.ArrayList;

public abstract class AbstractParallelCoordinatesMatrixView<Component, Color, Row, Column>
implements ParallelCoordinatesMatrixView<Component, Color> {
    protected ParallelCoordinatesMatrixModel<Color, Row, Column> model;
    protected ParallelCoordinates<Component, Color, Row, Column> parallelCoordinates;
    private final MutableProperties properties = new SimpleProperties();
    private final Property<Integer> maxDimensions = this.properties.createProperty((Object)"maxDimensions", (Object)20);
    private LicenseModel licenseModel;
    private final OrderListener orderListener = new OrderListener(){

        public void orderChanged(OrderEvent event) {
            AbstractParallelCoordinatesMatrixView.this.refresh();
        }

        public void orderVisibility(OrderEvent event) {
            AbstractParallelCoordinatesMatrixView.this.refresh();
        }

        public void orderAdded(OrderEvent event) {
            AbstractParallelCoordinatesMatrixView.this.refresh();
        }

        public void orderRemoved(OrderEvent event) {
            AbstractParallelCoordinatesMatrixView.this.refresh();
        }
    };

    public AbstractParallelCoordinatesMatrixView() {
        this.parallelCoordinates = this.createParallelCoordinates();
        this.setLicenseModel(this.licenseModel);
    }

    protected abstract ParallelCoordinates<Component, Color, Row, Column> createParallelCoordinates();

    @Override
    public ParallelCoordinatesMatrixModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(ParallelCoordinatesMatrixModel model) {
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().removeOrderListener(this.orderListener);
        }
        this.model = model;
        if (this.model != null) {
            this.updateParallelCoordinatesModel();
            this.model.getAxisGroupModel().getAxisOrder().addOrderListener(this.orderListener);
        }
    }

    protected abstract void refresh();

    protected abstract CPFactory<Component, ?, ?, Color> getFactory();

    protected void updateParallelCoordinatesModel() {
        DefaultAxisHierarchy axisHierarchy = new DefaultAxisHierarchy(this.model.getAxisHierarchy().getAxisFactory(), this.getFactory(), this.model.getDataFrame(), true, 10);
        DefaultParallelCoordinatesModel<Color, Row, Column> matrixModel = new DefaultParallelCoordinatesModel<Color, Row, Column>(this.model.getDataFrame(), this.model.getVisual(), axisHierarchy, new DefaultParallelCoordinatesSettings());
        MutableVisibleOrder axisOrder = this.model.getAxisGroupModel().getAxisOrder();
        int size = Math.min((Integer)this.maxDimensions.getValue(), axisOrder.size());
        int[][] h = AbstractParallelCoordinatesMatrixView.hamiltonianDecompositions(size);
        Hierarchy axisGroupHierarchy = matrixModel.getAxisHierarchy().getAxisGroupHierarchy();
        AxisGroupModel root = (AxisGroupModel)axisGroupHierarchy.getRoot();
        ArrayList<AxisModel> axes = new ArrayList<AxisModel>();
        for (AxisModel axisModel : root.getAxisOrder()) {
            axes.add(axisModel);
        }
        for (AxisModel axisModel : axes) {
            matrixModel.getAxisHierarchy().removeFromGroup(root, axisModel);
        }
        for (int i = 0; i < h.length; ++i) {
            int[] c = h[i];
            AxisModel[] axisModels = new AxisModel[c.length];
            for (int j = 0; j < c.length; ++j) {
                int index = c[j];
                axisModels[j] = matrixModel.getAxisHierarchy().createClonedAxisModel(((AxisModel)axisOrder.get(index)).getColumn());
            }
            root = matrixModel.getAxisHierarchy().createGroup(root, "Group " + (i + 1), axisModels);
        }
        this.parallelCoordinates.setModel(matrixModel);
    }

    @Override
    public boolean isShowTiming() {
        return this.parallelCoordinates.getView().isShowTiming();
    }

    @Override
    public void setShowTiming(boolean showTiming) {
        this.parallelCoordinates.getView().setShowTiming(showTiming);
    }

    @Override
    public boolean isSelectionMode() {
        return this.parallelCoordinates.getView().isSelectionMode();
    }

    @Override
    public void setSelectionMode(boolean value) {
        this.parallelCoordinates.getView().setSelectionMode(value);
    }

    @Override
    public void setLicenseModel(LicenseModel licenseModel) {
        this.parallelCoordinates.getView().setLicenseModel(licenseModel);
    }

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.parallelCoordinates.getView().getColorTheme();
    }

    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        this.parallelCoordinates.getView().setColorTheme(colorTheme);
    }

    private static int[][] hamiltonianDecompositions(int n) {
        int m = AbstractParallelCoordinatesMatrixView.getRowCount(n);
        int[][] h = n == 2 * m ? new int[m][n] : (n == 2 * m + 1 ? new int[m][2 * m + 2] : new int[m][2 * m + 2]);
        boolean even = n % 2 == 0;
        for (int k = 0; k < m; ++k) {
            for (int j = 0; j < 2 * m; ++j) {
                int v = AbstractParallelCoordinatesMatrixView.h(k + 1, j + 1, m, 2 * m);
                if (v < 0) {
                    v = 2 * m + v;
                }
                if (even) {
                    h[k][j] = v;
                    continue;
                }
                if (j == 0) {
                    h[k][j] = n - 1;
                    h[k][j + 1] = v;
                    h[k][2 * m + 1] = n - 1;
                    continue;
                }
                h[k][j + 1] = v;
            }
        }
        return h;
    }

    protected static int getRowCount(int n) {
        boolean even = n % 2 == 0;
        int m = even ? n / 2 : (n - 1) / 2;
        return m;
    }

    private static int h(int k, int j, int m, int n) {
        if (k == 1 && j == 1) {
            return 0;
        }
        if (k == 1) {
            return AbstractParallelCoordinatesMatrixView.h(1, j - 1, m, n) + (int)Math.pow(-1.0, j) * (j - 1) % n;
        }
        return AbstractParallelCoordinatesMatrixView.h(k - 1, j, m, n) + 1 % n;
    }

    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.parallelCoordinates.getView().setShowFiltered(showFiltered);
    }

    @Override
    public void setRendering(MutableProperty<CPCanvas.Rendering> rendering) {
        this.parallelCoordinates.getView().setRendering(rendering);
    }

    @Override
    public void setAntialiasing(MutableProperty<Boolean> antialiasing) {
        this.parallelCoordinates.getView().setAntialiasing(antialiasing);
    }
}

