/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix;

import com.macrofocus.common.properties.Property;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ScatterPlotMatrixComponent;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixListener;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixModel;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixView;
import com.macrofocus.igraphics.AbstractIDrawing;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.pressure.LogPressure;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.palette.FixedPalette;
import com.macrofocus.rubberband.RubberbandDrawing;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.timer.VisualizationExecutorService;
import com.macrofocus.visual.VisualLayer;
import com.macrofocus.visual.VisualListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractScatterPlotMatrixComponent<Component, Color, Row, Column>
implements ScatterPlotMatrixComponent<Component, Color, Row, Column> {
    private ScatterPlotMatrixView<Component, Color, Row, Column> view;
    protected final CPCanvas<Component> canvas;
    private CPFactory<?, ?, ?, Color> factory;
    private static final boolean MULTITHREADED = true;
    private static final VisualizationExecutorService executor = VisualizationExecutorService.getInstance();
    protected ScatterPlotMatrixModel<Color, Row, Column> model;
    protected final CPTimer timer;
    private final ScatterPlotMatrixListener listener = new ScatterPlotMatrixListener(){

        @Override
        public void scatterPlotMatrixChanged() {
            AbstractScatterPlotMatrixComponent.this.timer.restart();
        }
    };
    private final AxisListener axisListener = new AxisListener(){

        public void axisChanged() {
            AbstractScatterPlotMatrixComponent.this.scheduleUpdate();
        }
    };
    private final OrderListener<AxisModel> orderListener = new OrderListener<AxisModel>(){

        public void orderChanged(OrderEvent<AxisModel> event) {
            AbstractScatterPlotMatrixComponent.this.scheduleUpdate();
        }

        public void orderVisibility(OrderEvent<AxisModel> event) {
            AbstractScatterPlotMatrixComponent.this.scheduleUpdate();
        }

        public void orderAdded(OrderEvent<AxisModel> event) {
            AbstractScatterPlotMatrixComponent.this.scheduleUpdate();
        }

        public void orderRemoved(OrderEvent<AxisModel> event) {
            AbstractScatterPlotMatrixComponent.this.scheduleUpdate();
        }
    };

    public AbstractScatterPlotMatrixComponent(ScatterPlotMatrixView<Component, Color, Row, Column> view, CPFactory<Component, ?, ?, Color> factory) {
        this.view = view;
        this.canvas = factory.createCanvas();
        this.factory = factory;
        this.timer = factory.createTimer("ScatterPlotMatrixResizer", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                if (AbstractScatterPlotMatrixComponent.this.getWidth() > 0 && AbstractScatterPlotMatrixComponent.this.getHeight() > 0) {
                    AbstractScatterPlotMatrixComponent.this.refresh();
                }
            }
        });
    }

    protected void refresh() {
        this.canvas.refresh();
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void repaint();

    @Override
    public void setModel(ScatterPlotMatrixModel model) {
        if (this.model != null) {
            this.model.removeScatterPlotMatrixListener(this.listener);
            this.model.getAxisGroupModel().getAxisOrder().removeOrderListener(this.orderListener);
            this.model.getAxisGroupModel().removeAxisListener(this.axisListener);
        }
        this.model = model;
        if (this.model != null) {
            this.createOverplots();
            this.model.addScatterPlotMatrixListener(this.listener);
            this.model.getAxisGroupModel().getAxisOrder().addOrderListener(this.orderListener);
            this.model.getAxisGroupModel().addAxisListener(this.axisListener);
        }
        this.timer.restart();
    }

    @Override
    public void createOverplots() {
        if (this.model != null) {
            this.canvas.removeAllLayers();
            AbstractVisualLayerIDrawing filteredDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getFiltered()){

                @Override
                public boolean isActive() {
                    return (Boolean)AbstractScatterPlotMatrixComponent.this.view.getShowFiltered().getValue() != false && super.isActive();
                }

                @Override
                public void draw(IGraphics g, Point2D mp, Row row) {
                    g.drawPoint(mp);
                }
            };
            AbstractVisualLayerIDrawing visibleDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getVisible()){

                @Override
                public void draw(IGraphics g, Point2D mp, Row row) {
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                }
            };
            AbstractVisualLayerIDrawing colorMappedDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getColorMapped()){

                @Override
                public void draw(IGraphics g, Point2D mp, Row row) {
                    g.setColor(AbstractScatterPlotMatrixComponent.this.model.getColorMapping().getColor(row));
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                }
            };
            AbstractVisualLayerIDrawing coloredDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getColored()){

                @Override
                public void draw(IGraphics g, Point2D mp, Row row) {
                    g.setColor(AbstractScatterPlotMatrixComponent.this.model.getColoring().getColor(row));
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                }
            };
            AbstractVisualLayerIDrawing singleSelectedDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getSingleSelected()){

                @Override
                public void draw(IGraphics g, Point2D mp, Row row) {
                    g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getSelection());
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                }
            };
            AbstractVisualLayerIDrawing multiSelectedDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getMultipleSelected()){

                @Override
                public void draw(IGraphics g, Point2D mp, Row row) {
                    g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getSelection());
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                }
            };
            AbstractVisualLayerIDrawing probedDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getProbed()){

                @Override
                public void draw(IGraphics g, Point2D mp, Row row) {
                    g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getProbing());
                    int radius = 3;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                    if (AbstractScatterPlotMatrixComponent.this.model.getSelection().isSelected(row)) {
                        g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getSelection());
                        radius = 2;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                    }
                }
            };
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(){

                public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
                    g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getBackground());
                    g.fillRectangle(0, 0, AbstractScatterPlotMatrixComponent.this.getWidth(), AbstractScatterPlotMatrixComponent.this.getHeight());
                    for (int i = 0; i < AbstractScatterPlotMatrixComponent.this.model.getAxisCount(); ++i) {
                        AxisModel xAxisModel = AbstractScatterPlotMatrixComponent.this.model.getAxisModel(i);
                        Double location = AbstractScatterPlotMatrixComponent.this.model.getLocation(xAxisModel);
                        g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getForeground());
                        g.setLineWidth(3.0);
                        int x = (int)(location * (double)AbstractScatterPlotMatrixComponent.this.getWidth());
                        int y = (int)(location * (double)AbstractScatterPlotMatrixComponent.this.getHeight());
                        g.drawLine(x, 0, x, AbstractScatterPlotMatrixComponent.this.getHeight());
                        g.drawLine(0, y, AbstractScatterPlotMatrixComponent.this.getWidth(), y);
                    }
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)filteredDrawing, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getGhostedPalette();
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)visibleDrawing, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getVisiblePalette();
                }
            });
            this.canvas.addAveragingLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)colorMappedDrawing);
            this.canvas.addBufferedLayer((IDrawing)coloredDrawing);
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)multiSelectedDrawing, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractScatterPlotMatrixComponent.this.view.getColorTheme().getValue()).getSelectedPalette();
                }
            });
            this.canvas.addLayer((IDrawing)singleSelectedDrawing);
            this.canvas.addLayer((IDrawing)probedDrawing);
            this.canvas.addLayer((IDrawing)new RubberbandDrawing((CPColorFactory)this.factory, this.view.getRubberBand()){

                protected Property<ColorTheme<Color>> getColorTheme() {
                    return AbstractScatterPlotMatrixComponent.this.view.getColorTheme();
                }
            });
        }
    }

    @Override
    public Object getClosestRow(int x, int y) {
        for (int i = 0; i < this.model.getAxisCount(); ++i) {
            AxisModel xAxisModel = this.model.getAxisModel(i);
            Double x1Location = this.model.getLocation(xAxisModel);
            Double x2Location = i + 1 < this.model.getAxisCount() ? this.model.getLocation(this.model.getAxisModel(i + 1)) : Double.valueOf(1.0);
            if (x1Location == null || x2Location == null) continue;
            for (int j = 0; j < this.model.getAxisCount(); ++j) {
                if (i == j) continue;
                AxisModel yAxisModel = this.model.getAxisModel(j);
                Double y1Location = this.model.getLocation(yAxisModel);
                Double y2Location = j + 1 < this.model.getAxisCount() ? this.model.getLocation(this.model.getAxisModel(j + 1)) : Double.valueOf(1.0);
                if (y1Location == null || y2Location == null) continue;
                int x1 = (int)(x1Location * (double)this.getWidth());
                int y1 = (int)(y1Location * (double)this.getHeight());
                int x2 = (int)(x2Location * (double)this.getWidth());
                int y2 = (int)(y2Location * (double)this.getHeight());
                int width = x2 - x1;
                int height = y2 - y1;
                if (x < x1 || x > x2 || y < y1 || y > y2) continue;
                double minDistance = Double.MAX_VALUE;
                Object closest = null;
                VisualLayer visible = this.model.getVisual().getActive();
                for (Object row : visible) {
                    double distance;
                    Point2D mp = this.getPoint(0, row, xAxisModel, yAxisModel, x1, y1, width, height);
                    if (mp == null || !((distance = Point2D.distance((double)x, (double)y, (double)mp.getX(), (double)mp.getY())) < minDistance)) continue;
                    closest = row;
                    minDistance = distance;
                }
                return closest;
            }
        }
        return null;
    }

    @Override
    public List<Row> getRows(Rectangle2D rect) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.model.getAxisCount(); ++i) {
            AxisModel xAxisModel = this.model.getAxisModel(i);
            Double x1Location = this.model.getLocation(xAxisModel);
            Double x2Location = i + 1 < this.model.getAxisCount() ? this.model.getLocation(this.model.getAxisModel(i + 1)) : Double.valueOf(1.0);
            if (x1Location == null || x2Location == null) continue;
            for (int j = 0; j < this.model.getAxisCount(); ++j) {
                if (i == j) continue;
                AxisModel yAxisModel = this.model.getAxisModel(j);
                Double y1Location = this.model.getLocation(yAxisModel);
                Double y2Location = j + 1 < this.model.getAxisCount() ? this.model.getLocation(this.model.getAxisModel(j + 1)) : Double.valueOf(1.0);
                if (y1Location == null || y2Location == null) continue;
                int x1 = (int)(x1Location * (double)this.getWidth());
                int y1 = (int)(y1Location * (double)this.getHeight());
                int x2 = (int)(x2Location * (double)this.getWidth());
                int y2 = (int)(y2Location * (double)this.getHeight());
                int width = x2 - x1;
                int height = y2 - y1;
                if (!(rect.getX() >= (double)x1) || !(rect.getX() <= (double)x2) || !(rect.getY() >= (double)y1) || !(rect.getY() <= (double)y2)) continue;
                VisualLayer visible = this.model.getVisual().getActive();
                for (Object row : visible) {
                    Point2D mp = this.getPoint(0, row, xAxisModel, yAxisModel, x1, y1, width, height);
                    if (mp == null || !rect.contains(mp)) continue;
                    list.add(row);
                }
                return list;
            }
        }
        return list;
    }

    Point2D getPoint(int layer, Row row, AxisModel xAxisModel, AxisModel yAxisModel, int x, int y, int width, int height) {
        int inset = 5;
        x += 5;
        width -= 10;
        y += 5;
        height -= 10;
        Number v1 = xAxisModel.getValue(layer, row);
        Number v2 = yAxisModel.getValue(layer, row);
        if (v1 != null && v2 != null) {
            return new Point2D.Double((double)(x + (int)((double)(width - 1) * xAxisModel.getNormalized(v1.doubleValue()))), (double)(y + height - (int)((double)(height - 1) * yAxisModel.getNormalized(v2.doubleValue()))));
        }
        return null;
    }

    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    AbstractVisualLayerIDrawing.this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(final IGraphics g, Point2D point, double gw, double gh, Rectangle clipBounds) {
            block11: {
                if (this.visualLayer.getObjectCount() <= 0) break block11;
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        this.draw(g, row);
                    }
                } else {
                    int nTasks = Math.min(executor.getAvailableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    ArrayList<2> todo = new ArrayList<2>(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        final int fromRow = nTask * nRowsPerTask;
                        final int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(){
                            private final int from;
                            private final int to;
                            {
                                this.from = fromRow;
                                this.to = toRow;
                            }

                            @Override
                            public Object call() throws Exception {
                                for (Object row : AbstractVisualLayerIDrawing.this.visualLayer.iterable(this.from, this.to - 1)) {
                                    AbstractVisualLayerIDrawing.this.draw(g, row);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        List answers = executor.getExecutor().invokeAll(todo);
                        for (Future answer : answers) {
                            try {
                                answer.get();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (ExecutionException e) {
                                e.getCause().printStackTrace();
                            }
                        }
                    }
                    catch (InterruptedException answers) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        protected void draw(IGraphics g, Row row) {
            for (int i = 0; i < AbstractScatterPlotMatrixComponent.this.model.getAxisCount(); ++i) {
                AxisModel xAxisModel = AbstractScatterPlotMatrixComponent.this.model.getAxisModel(i);
                Double x1Location = AbstractScatterPlotMatrixComponent.this.model.getLocation(xAxisModel);
                Double x2Location = i + 1 < AbstractScatterPlotMatrixComponent.this.model.getAxisCount() ? AbstractScatterPlotMatrixComponent.this.model.getLocation(AbstractScatterPlotMatrixComponent.this.model.getAxisModel(i + 1)) : Double.valueOf(1.0);
                if (x1Location == null || x2Location == null) continue;
                for (int j = 0; j < AbstractScatterPlotMatrixComponent.this.model.getAxisCount(); ++j) {
                    if (i == j) continue;
                    AxisModel yAxisModel = AbstractScatterPlotMatrixComponent.this.model.getAxisModel(j);
                    Double y1Location = AbstractScatterPlotMatrixComponent.this.model.getLocation(yAxisModel);
                    Double y2Location = j + 1 < AbstractScatterPlotMatrixComponent.this.model.getAxisCount() ? AbstractScatterPlotMatrixComponent.this.model.getLocation(AbstractScatterPlotMatrixComponent.this.model.getAxisModel(j + 1)) : Double.valueOf(1.0);
                    if (y1Location == null || y2Location == null) continue;
                    int x = (int)(x1Location * (double)AbstractScatterPlotMatrixComponent.this.getWidth());
                    int y = (int)(y1Location * (double)AbstractScatterPlotMatrixComponent.this.getHeight());
                    int width = (int)(x2Location * (double)AbstractScatterPlotMatrixComponent.this.getWidth()) - x;
                    int height = (int)(y2Location * (double)AbstractScatterPlotMatrixComponent.this.getHeight()) - y;
                    Point2D mp = AbstractScatterPlotMatrixComponent.this.getPoint(this.getLayer(), row, xAxisModel, yAxisModel, x, y, width, height);
                    if (mp == null) continue;
                    this.draw(g, mp, row);
                }
            }
        }

        public int getLayer() {
            return 0;
        }

        public abstract void draw(IGraphics var1, Point2D var2, Row var3);
    }
}

