/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixController;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixView;
import java.util.Collection;
import java.util.List;

public abstract class AbstractScatterPlotMatrixController<Component, Color, Row, Column>
implements ScatterPlotMatrixController<Component, Color, Row, Column> {
    private ScatterPlotMatrixView<Component, Color, Row, Column> view;
    private final boolean multipleSelectionEnabled = true;
    private final boolean selectOnPopupTrigger = false;
    private ScatterPlotMatrixController.Mode mode = ScatterPlotMatrixController.Mode.Selection;
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();

    public AbstractScatterPlotMatrixController() {
    }

    public AbstractScatterPlotMatrixController(ScatterPlotMatrixView<Component, Color, Row, Column> view) {
        this();
        this.setView(view);
    }

    @Override
    public void setView(ScatterPlotMatrixView<Component, Color, Row, Column> view) {
        if (this.view != null) {
            this.view.removeMouseListener(this.mouseListener);
            this.view.removeMouseMotionListener(this.mouseListener);
        }
        this.view = view;
        if (view != null) {
            view.addMouseListener(this.mouseListener);
            view.addMouseMotionListener(this.mouseListener);
        }
    }

    public ScatterPlotMatrixView<Component, Color, Row, Column> getView() {
        return this.view;
    }

    @Override
    public ScatterPlotMatrixController.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(ScatterPlotMatrixController.Mode mode) {
        this.mode = mode;
    }

    private void removeFromSelection(Object observation) {
        this.getView().getModel().getSelection().setSelectedState(observation, false);
    }

    private void setSelection(Object observation) {
        if (observation != null) {
            this.getView().getModel().getSelection().setSelectedElements(new Object[]{observation});
        } else {
            this.getView().getModel().getSelection().clearSelection();
        }
    }

    private void addToSelection(Object observation) {
        this.getView().getModel().getSelection().setSelectedState(observation, true);
    }

    private void addToSelection(Collection<Object> newSelection) {
        this.getView().getModel().getSelection().setSelectedIterableState(newSelection, true);
    }

    public class DefaultMouseListener
    implements CPCanvas.MouseListener,
    CPCanvas.MouseMotionListener {
        private Point last;
        private Object selectOnRelease = null;
        private Point zoomOnRelease = null;
        private Point zoomingPoint = null;
        private Point pressedPoint = null;

        public void mouseClicked(CPCanvas.MouseEvent e) {
        }

        public void mousePressed(CPCanvas.MouseEvent event) {
            if (AbstractScatterPlotMatrixController.this.getView() != null) {
                this.pressedPoint = new Point(event.getX(), event.getY());
                Object bestrow = AbstractScatterPlotMatrixController.this.getView().getClosestRow(event.getX(), event.getY());
                switch (AbstractScatterPlotMatrixController.this.getMode()) {
                    case Selection: {
                        if (bestrow != null) {
                            if (!event.isMultipleSelectionKey()) {
                                if (AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().isSelected(bestrow) && AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().getSelectedCount() <= 1) break;
                                AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().clearSelection();
                                AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().setSelected(bestrow);
                                AbstractScatterPlotMatrixController.this.getView().setSelectionMode(AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().isSelected(bestrow));
                                break;
                            }
                            AbstractScatterPlotMatrixController.this.getView().setSelectionMode(!AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().isSelected(bestrow));
                            if (AbstractScatterPlotMatrixController.this.getView().isSelectionMode()) {
                                AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().setSelectedState(bestrow, true);
                                break;
                            }
                            AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().setSelectedState(bestrow, false);
                            break;
                        }
                        AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().clearSelection();
                        break;
                    }
                    case Toggle: {
                        boolean selected = AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().isSelected(bestrow);
                        AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().setSelectedState(bestrow, !selected);
                        break;
                    }
                    case Filter: {
                        boolean filtered = AbstractScatterPlotMatrixController.this.getView().getModel().getFilter().isFilteredBy(bestrow, (Object)this);
                        AbstractScatterPlotMatrixController.this.getView().getModel().getFilter().setFiltered(bestrow, !filtered, (Object)this);
                    }
                }
            }
        }

        public void mouseReleased(CPCanvas.MouseEvent event) {
            if (AbstractScatterPlotMatrixController.this.getView() != null) {
                if (!event.isPopupTrigger()) {
                    switch (AbstractScatterPlotMatrixController.this.getMode()) {
                        case Selection: {
                            if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                                AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().clearSelection();
                                AbstractScatterPlotMatrixController.this.addToSelection(this.selectOnRelease);
                                this.selectOnRelease = null;
                            }
                            if (this.zoomOnRelease != null) {
                                if (event.isLeftMouseButton()) {
                                    // empty if block
                                }
                                this.zoomOnRelease = null;
                            }
                            AbstractScatterPlotMatrixController.this.getView().getRubberBand().stopRubberBand();
                            break;
                        }
                        case Toggle: {
                            if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                                AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().clearSelection();
                                AbstractScatterPlotMatrixController.this.addToSelection(this.selectOnRelease);
                                this.selectOnRelease = null;
                            }
                            if (this.zoomOnRelease != null) {
                                if (event.isLeftMouseButton()) {
                                    // empty if block
                                }
                                this.zoomOnRelease = null;
                            }
                            AbstractScatterPlotMatrixController.this.getView().getRubberBand().stopRubberBand();
                            break;
                        }
                    }
                }
                this.last = null;
            }
        }

        public void mouseEntered(CPCanvas.MouseEvent e) {
        }

        public void mouseExited(CPCanvas.MouseEvent e) {
            AbstractScatterPlotMatrixController.this.getView().getModel().getProbing().clearSelection();
        }

        public void mouseDragged(CPCanvas.MouseEvent event) {
            if (AbstractScatterPlotMatrixController.this.getView() != null && AbstractScatterPlotMatrixController.this.getView().getModel() != null) {
                Point point = new Point(event.getX(), event.getY());
                if (this.last != null) {
                    switch (AbstractScatterPlotMatrixController.this.getMode()) {
                        case Selection: {
                            boolean isAlreadySelected;
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                AbstractScatterPlotMatrixController.this.getView().getModel().getProbing().clearSelection();
                                if (!AbstractScatterPlotMatrixController.this.getView().getRubberBand().getRubberBand().isActive()) {
                                    AbstractScatterPlotMatrixController.this.getView().getRubberBand().startRubberBand(this.pressedPoint.x, this.pressedPoint.y);
                                }
                                AbstractScatterPlotMatrixController.this.getView().getRubberBand().stretchRubberBand(event.getX(), event.getY());
                                Rectangle2D rect = AbstractScatterPlotMatrixController.this.getView().getRubberBand().getRubberBandScreen();
                                if (rect == null) break;
                                List toSelect = AbstractScatterPlotMatrixController.this.getView().getRows(rect);
                                if (event.isMultipleSelectionKey()) {
                                    AbstractScatterPlotMatrixController.this.addToSelection((Object)toSelect);
                                } else {
                                    AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().setSelectedIterable(toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            Object observation = AbstractScatterPlotMatrixController.this.getView().getClosestRow(point.x, point.y);
                            AbstractScatterPlotMatrixController.this.getView().getModel().getProbing().setSelected(observation);
                            this.selectOnRelease = null;
                            boolean bl = isAlreadySelected = AbstractScatterPlotMatrixController.this.getView().getModel().getSelection() != null && AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().isSelected(observation);
                            if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                                AbstractScatterPlotMatrixController.this.getView().getModel().getSelection().clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                AbstractScatterPlotMatrixController.this.addToSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            AbstractScatterPlotMatrixController.this.addToSelection(observation);
                        }
                    }
                }
                this.last = new Point(event.getX(), event.getY());
            }
        }

        public void mouseMoved(CPCanvas.MouseEvent event) {
            Object closest = AbstractScatterPlotMatrixController.this.getView().getClosestRow(event.getX(), event.getY());
            AbstractScatterPlotMatrixController.this.getView().getModel().getProbing().setSelected(closest);
        }
    }
}

