/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens;

import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.high_d.tablelens.TableLensView;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.rubberband.RubberBand;
import com.macrofocus.rubberband.SimpleRubberBand;

public abstract class AbstractTableLensView<Component, Color, Row, Column>
implements TableLensView<Component, Color, Row, Column> {
    protected final MutableProperties<TableLensView.PropertyType> properties = new EnumProperties(TableLensView.PropertyType.class);
    private final RubberBand rubberBand;
    protected final OrderListener orderListener = new OrderListener(){

        public void orderChanged(OrderEvent event) {
            AbstractTableLensView.this.refresh();
        }

        public void orderVisibility(OrderEvent event) {
            AbstractTableLensView.this.refresh();
        }

        public void orderAdded(OrderEvent event) {
            AbstractTableLensView.this.refresh();
        }

        public void orderRemoved(OrderEvent event) {
            AbstractTableLensView.this.refresh();
        }
    };
    private final PropertiesListener<TableLensView.PropertyType> propertiesListener = new PropertiesListener<TableLensView.PropertyType>(){

        public void propertyChanged(TableLensView.PropertyType name, PropertyEvent event) {
            AbstractTableLensView.this.createOverplots();
        }
    };

    protected AbstractTableLensView(CPColorFactory<Color> factory) {
        this.properties.createProperty((Object)TableLensView.PropertyType.ShowTiming, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)TableLensView.PropertyType.ShowFiltered, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)TableLensView.PropertyType.Antialiasing, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)TableLensView.PropertyType.Rendering, (Object)CPCanvas.Rendering.Density);
        this.properties.createProperty((Object)TableLensView.PropertyType.ColumnSize, (Object)45);
        this.properties.createProperty((Object)TableLensView.PropertyType.RowSize, (Object)0);
        this.properties.createProperty((Object)TableLensView.PropertyType.ColorTheme, (Object)new LightColorTheme(factory));
        this.properties.addPropertiesListener(this.propertiesListener);
        this.rubberBand = new SimpleRubberBand();
    }

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.properties.getProperty((Object)TableLensView.PropertyType.ColorTheme);
    }

    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        this.properties.replaceProperty((Object)TableLensView.PropertyType.ColorTheme, colorTheme);
    }

    @Override
    public boolean isShowTiming() {
        return (Boolean)this.properties.getProperty((Object)TableLensView.PropertyType.ShowTiming).getValue();
    }

    @Override
    public void setShowTiming(boolean showTiming) {
        this.properties.getProperty((Object)TableLensView.PropertyType.ShowTiming).setValue((Object)showTiming);
    }

    @Override
    public Property<Boolean> getShowFiltered() {
        return this.properties.getProperty((Object)TableLensView.PropertyType.ShowFiltered);
    }

    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)TableLensView.PropertyType.ShowFiltered, showFiltered);
        this.createOverplots();
    }

    @Override
    public MutableProperty<Boolean> getAntialiasing() {
        return this.properties.getProperty((Object)TableLensView.PropertyType.Antialiasing);
    }

    @Override
    public void setAntialiasing(MutableProperty<Boolean> antialiasing) {
        this.properties.replaceProperty((Object)TableLensView.PropertyType.Antialiasing, antialiasing);
        this.createOverplots();
    }

    @Override
    public MutableProperty<CPCanvas.Rendering> getRendering() {
        return this.properties.getProperty((Object)TableLensView.PropertyType.Rendering);
    }

    @Override
    public void setRendering(MutableProperty<CPCanvas.Rendering> rendering) {
        this.properties.replaceProperty((Object)TableLensView.PropertyType.Rendering, rendering);
        this.createOverplots();
    }

    @Override
    public MutableProperty<Integer> getColumnSize() {
        return this.properties.getProperty((Object)TableLensView.PropertyType.ColumnSize);
    }

    @Override
    public MutableProperty<Integer> getRowSize() {
        return this.properties.getProperty((Object)TableLensView.PropertyType.RowSize);
    }

    protected abstract void createOverplots();

    protected abstract void refresh();

    @Override
    public RubberBand getRubberBand() {
        return this.rubberBand;
    }
}

