/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal;

import com.ejt.internal.CommonApplicationServices;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.List;

public class ObfuscatedDelegate
extends CommonApplicationServices {
    private final WeakReference<Object> instanceRef;
    private final Method getWindowImageIcons;
    private final Method isFrameworkWindow;
    private final Method beforeAlertOn;
    private final Method getApplicationName;
    private final Method confirmOverwrite;
    private final Method isLocalized;
    private final Method getPreferenceRootPath;

    public ObfuscatedDelegate(Class<?> delegateClass, Object instance) {
        this.instanceRef = new WeakReference<Object>(instance);
        this.getWindowImageIcons = this.getDelegateMethod(delegateClass, "getWindowImageIcons", new Class[0]);
        this.isFrameworkWindow = this.getDelegateMethod(delegateClass, "isFrameworkWindow", Window.class);
        this.beforeAlertOn = this.getDelegateMethod(delegateClass, "beforeAlertOn", Window.class);
        this.getApplicationName = this.getDelegateMethod(delegateClass, "getApplicationName", new Class[0]);
        this.confirmOverwrite = this.getDelegateMethod(delegateClass, "confirmOverwrite", Window.class, File.class);
        this.isLocalized = this.getDelegateMethod(delegateClass, "isLocalized", new Class[0]);
        this.getPreferenceRootPath = this.getDelegateMethod(delegateClass, "getPreferenceRootPath", new Class[0]);
    }

    public boolean isAlive() {
        return this.instanceRef.get() != null;
    }

    private Method getDelegateMethod(Class<?> delegateClass, String methodName, Class ... argumentClasses) {
        try {
            return delegateClass.getDeclaredMethod(methodName, argumentClasses);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> T invokeMethod(Method method, Object ... arguments) {
        return this.invokeMethod((T)null, method, arguments);
    }

    private <T> T invokeMethod(T defaultValue, Method method, Object ... arguments) {
        try {
            Object instance = this.instanceRef.get();
            if (method != null && instance != null) {
                return (T)method.invoke(instance, arguments);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return defaultValue;
    }

    @Override
    public List<? extends Image> getWindowImageIcons() {
        return (List)this.invokeMethod(this.getWindowImageIcons, new Object[0]);
    }

    @Override
    public boolean isFrameworkWindow(Window window) {
        return this.invokeMethod(true, this.isFrameworkWindow, window);
    }

    @Override
    public void beforeAlertOn(Window parentWindow) {
        this.invokeMethod(true, this.beforeAlertOn, parentWindow);
    }

    @Override
    public String getApplicationName() {
        return this.invokeMethod("application", this.getApplicationName, new Object[0]);
    }

    @Override
    public boolean confirmOverwrite(Window parent, File selectedFile) {
        return this.invokeMethod(false, this.confirmOverwrite, parent, selectedFile);
    }

    @Override
    public boolean isLocalized() {
        return this.invokeMethod(false, this.isLocalized, new Object[0]);
    }

    @Override
    public String getPreferenceRootPath() {
        return (String)this.invokeMethod(this.getPreferenceRootPath, new Object[0]);
    }
}

