/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter;

import com.macrofocus.common.annotations.GwtIncompatible;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.DataFrameWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.TimeZone;

public class DelimitedDataFrameWriter
implements DataFrameWriter {
    private final StringBuilder a;
    private int b;
    private String c;
    private String d;
    private int e = 0;
    private int f = 0;

    /*
     * WARNING - void declaration
     */
    public DelimitedDataFrameWriter(StringBuilder writer, int columnCount, String delimiter, String newLine) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = newLine;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    @GwtIncompatible
    public void setTimeZone(TimeZone timeZone) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeColumnName(String value, boolean hasMore) throws IOException {
        void var2_2;
        if (value != null) {
            void var1_1;
            if (((String)value).contains(this.c) || ((String)value).contains("\"") || ((String)value).contains("\n")) {
                value = "\"" + ((String)value).replaceAll("\"", "\"\"") + "\"";
            }
            this.a.append((String)var1_1);
        }
        this.nextColumn((boolean)var2_2);
    }

    @Override
    public boolean includeType() {
        return false;
    }

    @Override
    public void writeType(Class cl, boolean hasMore) throws IOException {
    }

    @Override
    public void writeCell(Object value, DataFrame dataFrame, Object rowKey, Object columnKey) throws IOException {
        if (value != null) {
            Object object;
            if (value instanceof String[]) {
                String[] stringArray = (String[])value;
                object = "";
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2];
                    object = (String)object + string;
                    if (i2 >= stringArray.length - 1) continue;
                    object = (String)object + ".";
                }
            } else if (((String)(object = object instanceof Number ? DelimitedDataFrameWriter.numberToString((Number)object) : object.toString())).contains(this.c) || ((String)object).contains("\"") || ((String)object).contains("\n")) {
                object = "\"" + ((String)object).replaceAll("\"", "\"\"") + "\"";
            }
            this.a.append((String)object);
        }
    }

    public static String numberToString(Number value) {
        Number number;
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            double d2 = value.doubleValue();
            if (Double.isNaN(d2)) {
                return "";
            }
            if (Double.isInfinite(d2)) {
                return Double.toString(d2);
            }
            return new BigDecimal(d2, new MathContext(15, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
        }
        if (value instanceof Float) {
            float f2 = value.floatValue();
            if (Float.isNaN(f2)) {
                return "";
            }
            if (Float.isInfinite(f2)) {
                return Float.toString(f2);
            }
            return new BigDecimal(f2, new MathContext(6, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
        }
        if (value instanceof Long) {
            long l2 = value.longValue();
            return Long.toString(l2);
        }
        if (value instanceof Integer) {
            int n2 = value.intValue();
            return Integer.toString(n2);
        }
        if (value instanceof Byte) {
            byte by = value.byteValue();
            return Byte.toString(by);
        }
        if (value instanceof Short) {
            short s2 = value.shortValue();
            return Short.toString(s2);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        return number.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void nextColumn(boolean hasMore) throws IOException {
        void var1_1;
        ++this.f;
        if (var1_1 != false) {
            this.a.append(this.c);
        }
    }

    @Override
    public void nextRow() throws IOException {
        this.f = 0;
        ++this.e;
        this.a.append(this.d);
    }

    @Override
    public void close() throws IOException {
    }
}

