/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;

public abstract class BinaryExpression
extends AbstractExpression {
    protected int m_op;
    protected Expression m_left;
    protected Expression m_right;

    /*
     * WARNING - void declaration
     */
    protected BinaryExpression(int operation, int minOp, int maxOp, Expression left, Expression right) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (operation < var2_2 || operation > var3_3) {
            throw new IllegalArgumentException("Unknown operation type: " + operation);
        }
        if (left == null || right == null) {
            throw new IllegalArgumentException("Expressions must be non-null.");
        }
        this.m_op = var1_1;
        this.m_left = left;
        this.m_right = right;
    }

    public Expression getLeftExpression() {
        return this.m_left;
    }

    public Expression getRightExpression() {
        return this.m_right;
    }

    /*
     * WARNING - void declaration
     */
    public void setLeftExpression(Expression e2) {
        this.m_left.removeExpressionListener(this);
        this.m_left = e2;
        if (this.hasListeners()) {
            void var1_1;
            var1_1.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    /*
     * WARNING - void declaration
     */
    public void setRightExpression(Expression e2) {
        this.m_right.removeExpressionListener(this);
        this.m_right = e2;
        if (this.hasListeners()) {
            void var1_1;
            var1_1.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public int getOperation() {
        return this.m_op;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(ExpressionVisitor v2) {
        void var1_1;
        v2.visitExpression(this);
        v2.down();
        this.m_left.visit(v2);
        v2.up();
        v2.down();
        this.m_right.visit(v2);
        var1_1.up();
    }

    @Override
    protected void addChildListeners() {
        this.m_left.addExpressionListener(this);
        this.m_right.addExpressionListener(this);
    }

    @Override
    protected void removeChildListeners() {
        this.m_left.removeExpressionListener(this);
        this.m_right.removeExpressionListener(this);
    }
}

