/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    List<byte[]> dataElement;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading variableRecord: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = sPSSFile.readSPSSInt();
        this.dataElementLength = sPSSFile.readSPSSInt();
        this.numberOfDataElements = sPSSFile.readSPSSInt();
        this.dataElement = new ArrayList<byte[]>();
        byte[] byArray = new byte[this.dataElementLength];
        for (int i = 0; i < this.numberOfDataElements; ++i) {
            sPSSFile.read(byArray);
            this.dataElement.add(byArray);
        }
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 7 - GENERIC";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nRecord Subtype  : " + this.recordSubtypeCode;
        string = string + "\nData elements   : " + this.numberOfDataElements;
        string = string + "\nElement length  : " + this.dataElementLength;
        return string;
    }
}

