/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix;

import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.stat.MinMaxMatrixModel;

public final class ScaledMatrixModel
extends AbstractMatrixModel {
    private MatrixModel _dataset;
    private MinMaxMatrixModel _minmax;
    private double from;
    private double to;
    private double range;

    public ScaledMatrixModel(MatrixModel dataset, MinMaxMatrixModel minmax) {
        this(dataset, minmax, 0.0, 1.0);
    }

    public ScaledMatrixModel(MatrixModel dataset, MinMaxMatrixModel minmax, double from, double to) {
        this._dataset = dataset;
        this._minmax = minmax;
        this.from = from;
        this.to = to;
        this.range = to - from;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getDouble(row, column);
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this._dataset.isAvailable(row, column);
    }

    @Override
    public int getRowCount() {
        return this._dataset.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._dataset.getColumnCount();
    }

    @Override
    public double getDouble(int row, int column) {
        return (this._dataset.getDouble(row, column) - this._minmax.getMin(column)) / this._minmax.getRange(column) * this.range + this.from;
    }

    @Override
    public Object getColumnName(int column) {
        return this._dataset.getColumnName(column);
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public Class getColumnClass(int column) {
        return Double.class;
    }
}

