/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.stat;

import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.MatrixModel;

public class ColumnCorrelationMatrixModel
extends AbstractMatrixModel {
    private final MatrixModel matrixModel;
    private final double[] mean;
    private final double[] stddev;
    private final double[] sum;
    private final int[] count;

    public ColumnCorrelationMatrixModel(MatrixModel matrixModel) {
        int row;
        int column;
        this.matrixModel = matrixModel;
        this.mean = new double[matrixModel.getColumnCount()];
        this.stddev = new double[matrixModel.getColumnCount()];
        this.sum = new double[matrixModel.getColumnCount()];
        this.count = new int[matrixModel.getColumnCount()];
        for (column = 0; column < matrixModel.getColumnCount(); ++column) {
            this.mean[column] = 0.0;
            this.stddev[column] = 0.0;
            this.sum[column] = 0.0;
            this.count[column] = 0;
        }
        for (column = 0; column < matrixModel.getColumnCount(); ++column) {
            for (row = 0; row < matrixModel.getRowCount(); ++row) {
                if (!matrixModel.isAvailable(row, column)) continue;
                int n = column;
                this.count[n] = this.count[n] + 1;
                int n2 = column;
                this.sum[n2] = this.sum[n2] + matrixModel.getDouble(row, column);
            }
            this.mean[column] = this.sum[column] / (double)this.count[column];
        }
        for (column = 0; column < matrixModel.getColumnCount(); ++column) {
            for (row = 0; row < matrixModel.getRowCount(); ++row) {
                if (!matrixModel.isAvailable(row, column)) continue;
                double var = matrixModel.getDouble(row, column) - this.mean[column];
                int n = column;
                this.stddev[n] = this.stddev[n] + var * var;
            }
            this.stddev[column] = Math.sqrt(this.stddev[column]);
        }
    }

    @Override
    public Object getColumnName(int column) {
        return this.matrixModel.getColumnName(column);
    }

    @Override
    public int getRowCount() {
        return this.matrixModel.getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return this.matrixModel.getColumnCount();
    }

    @Override
    public double getDouble(int row, int column) {
        double r = 0.0;
        int n = 0;
        for (int i = 0; i < this.matrixModel.getRowCount(); ++i) {
            if (!this.matrixModel.isAvailable(i, row) || !this.matrixModel.isAvailable(i, column)) continue;
            r += (this.matrixModel.getDouble(i, row) - this.mean[row]) * (this.matrixModel.getDouble(i, column) - this.mean[column]);
            ++n;
        }
        if ((r /= this.stddev[row] * this.stddev[column]) > 1.0) {
            r = 1.0;
        }
        if (r < -1.0) {
            r = 1.0;
        }
        return r;
    }
}

