/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.stat;

import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.vector.RowMatrixModelVectorModel;
import com.macrofocus.data.matrix.vector.VectorModel;

public final class StatMatrixModel
extends AbstractMatrixModel {
    private double[] _avg;
    private double[] _stdev;
    private double[] count;
    private MatrixModel matrixModel;

    public StatMatrixModel(MatrixModel matrixModel) {
        int j;
        this.matrixModel = matrixModel;
        this._avg = new double[matrixModel.getColumnCount()];
        this._stdev = new double[matrixModel.getColumnCount()];
        this.count = new double[matrixModel.getColumnCount()];
        for (j = 0; j < matrixModel.getColumnCount(); ++j) {
            this._avg[j] = 0.0;
            this._stdev[j] = 0.0;
            this.count[j] = 0.0;
        }
        for (int i = 0; i < matrixModel.getRowCount(); ++i) {
            for (int j2 = 0; j2 < matrixModel.getColumnCount(); ++j2) {
                if (!matrixModel.isAvailable(i, j2)) continue;
                double value = matrixModel.getDouble(i, j2);
                int n = j2;
                this._avg[n] = this._avg[n] + value;
                int n2 = j2;
                this.count[n2] = this.count[n2] + 1.0;
            }
        }
        for (j = 0; j < matrixModel.getColumnCount(); ++j) {
            int n = j;
            this._avg[n] = this._avg[n] / this.count[j];
        }
        for (j = 0; j < matrixModel.getColumnCount(); ++j) {
            double squareSum = 0.0;
            double sum = 0.0;
            for (int i = 0; i < matrixModel.getRowCount(); ++i) {
                if (!matrixModel.isAvailable(i, j)) continue;
                double value = matrixModel.getDouble(i, j) - this._avg[j];
                squareSum += Math.pow(value, 2.0);
                sum += value;
            }
            this._stdev[j] = squareSum;
        }
        for (j = 0; j < matrixModel.getColumnCount(); ++j) {
            this._stdev[j] = Math.sqrt(this._stdev[j] / this.count[j]);
        }
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return true;
    }

    @Override
    public int getRowCount() {
        return 2;
    }

    @Override
    public int getColumnCount() {
        return this.matrixModel.getColumnCount();
    }

    @Override
    public double getDouble(int row, int column) {
        if (row == 0) {
            return this.getAvg(column);
        }
        return this.getStdev(column);
    }

    public void setDouble(int row, int column, double value) {
    }

    public double getAvg(int column) {
        return this._avg[column];
    }

    public double getStdev(int column) {
        return this._stdev[column];
    }

    public double getCount(int column) {
        return this.count[column];
    }

    @Override
    public Object getColumnName(int column) {
        return this.matrixModel.getColumnName(column);
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
        }
        return index;
    }

    public VectorModel getAvgVectorModel() {
        return new RowMatrixModelVectorModel(this, 0);
    }

    public VectorModel getStdevVectorModel() {
        return new RowMatrixModelVectorModel(this, 1);
    }
}

