/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.google.gdata.client.Query;
import com.google.gdata.client.analytics.AnalyticsService;
import com.google.gdata.client.analytics.DataQuery;
import com.google.gdata.data.analytics.DataEntry;
import com.google.gdata.data.analytics.DataFeed;
import com.google.gdata.data.analytics.Dimension;
import com.google.gdata.data.analytics.Metric;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import nu.xom.Document;

public class GoogleAnalyticsDataSource
extends AbstractDataSource {
    static final String type = "GoogleAnalytics";
    private final String username;
    private final String password;
    private final String spreadsheet;
    private static final Map<String, AnalyticsColumn> ANALYTICS_COLUMNS;

    public GoogleAnalyticsDataSource(String username, String password, String spreadsheet) {
        this.username = username;
        this.password = password;
        this.spreadsheet = spreadsheet;
    }

    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        AnalyticsService service = new AnalyticsService("macrofocus-data");
        try {
            service.setUserCredentials(this.username, this.password);
            System.err.println(service);
            ColumnTypeMap columnTypeMap = new ColumnTypeMap();
            columnTypeMap.put(0, ANALYTICS_COLUMNS.get("ga:date"));
            columnTypeMap.put(1, ANALYTICS_COLUMNS.get("ga:pagePath"));
            columnTypeMap.put(2, ANALYTICS_COLUMNS.get("ga:country"));
            columnTypeMap.put(3, ANALYTICS_COLUMNS.get("ga:visitors"));
            columnTypeMap.put(4, ANALYTICS_COLUMNS.get("ga:bounces"));
            String id = "UA-23564919-2";
            List<DataEntry> entries = this.getAnalyticsData(service, "ga:46354299", columnTypeMap, "2012-01-01", "2012-05-01");
            for (DataEntry entry : entries) {
                System.err.println();
                System.err.println("Metric");
                for (Metric metric : entry.getMetrics()) {
                    System.err.print(metric.getName() + ": " + metric.getValue() + " ");
                }
                System.err.println();
                System.err.println("Dimensions");
                for (Dimension dimension : entry.getDimensions()) {
                    System.err.print(dimension.getName() + ": " + dimension.getValue() + " ");
                }
            }
        }
        catch (AuthenticationException e) {
            SwingLogging.getInstance().process(contentPane, (Throwable)e);
        }
        catch (ServiceException e) {
            SwingLogging.getInstance().process(contentPane, (Throwable)e);
        }
        return null;
    }

    private List<DataEntry> getAnalyticsData(AnalyticsService analyticsService, String tableId, ColumnTypeMap columnTypeMap, String startDate, String endDate) throws IOException, ServiceException {
        DataQuery query = new DataQuery(new URL("https://www.google.com/analytics/feeds/data"));
        query.setIds(tableId);
        query.setDimensions(columnTypeMap.getColumnString(ColumnType.DIMENSION));
        query.setMetrics(columnTypeMap.getColumnString(ColumnType.METRIC));
        query.setStartDate(startDate);
        query.setEndDate(endDate);
        DataFeed feed = (DataFeed)analyticsService.getFeed((Query)query, DataFeed.class);
        return feed.getEntries();
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        return dataSource;
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }

    static {
        String[] dimensions = new String[]{"ga:date", "ga:hour", "ga:month", "ga:week", "ga:year", "ga:adGroup", "ga:adSlot", "ga:adSlotPosition", "ga:affiliation", "ga:browser", "ga:browserVersion", "ga:campaign", "ga:city", "ga:connectionSpeed", "ga:content", "ga:continent", "ga:country", "ga:day", "ga:daysSinceLastVisit", "ga:daysToTransaction", "ga:networkDomain", "ga:flashVersion", "ga:searchUsed", "ga:hostname", "ga:searchKeyword", "ga:searchKeywordRefinement", "ga:searchCategory", "ga:javaSupport", "ga:keyword", "ga:language", "ga:latitude", "ga:longitude", "ga:medium", "ga:networkLocation", "ga:pageDepth", "ga:pageTitle", "ga:operatingSystem", "ga:operatingSystemVersion", "ga:productSku", "ga:productName", "ga:productCategory", "ga:referralPath", "ga:region", "ga:pagePath", "ga:landingPagePath", "ga:searchStartPage", "ga:exitPagePath", "ga:searchDestinationPage", "ga:screenColors", "ga:screenResolution", "ga:source", "ga:sourceMedium", "ga:subContinent", "ga:transactionId", "ga:userDefinedValue", "ga:visitorType"};
        String[] metrics = new String[]{"ga:totalAbandonmentRate", "ga:abandonedFunnels", "ga:goal1AbandonmentRate", "ga:goal2AbandonmentRate", "ga:goal3AbandonmentRate", "ga:goal4AbandonmentRate", "ga:costPerGoalConversion", "ga:costPerTransaction", "ga:costPerConversion", "ga:goalConversionRate", "ga:goal1AbandonedFunnels", "ga:goal2AbandonedFunnels", "ga:goal3AbandonedFunnels", "ga:goal4AbandonedFunnels", "ga:perVisitGoalValue", "ga:visitors", "ga:rpc", "ga:bounces", "ga:bounceRate", "ga:adClicks", "ga:CTR", "ga:adCost", "ga:CPM", "ga:CPC", "ga:entrances", "ga:exits", "ga:percentExit", "ga:totalGoalCompletions", "ga:goal1Completions", "ga:goal1ConversionRate", "ga:goal2Completions", "ga:goal2ConversionRate", "ga:goal3Completions", "ga:goal3ConversionRate", "ga:goal4Completions", "ga:goal4ConversionRate", "ga:totalGoalStarts", "ga:goal1Starts", "ga:goal2Starts", "ga:goal3Starts", "ga:goal4Starts", "ga:totalGoalValue", "ga:goal1Value", "ga:goal2Value", "ga:goal3Value", "ga:goal4Value", "ga:impressions", "ga:newVisits", "ga:percentNewVisits", "ga:timeOnPage", "ga:avgTimeOnPage", "ga:pageviews", "ga:pagesPerVisit", "ga:itemQuantity", "ga:itemRevenue", "ga:uniquePurchases", "ga:transactionRevenue", "ga:averageValue", "ga:perVisitValue", "ga:searchDepth", "ga:searchDuration", "ga:searchExits", "ga:searchRefinements", "ga:transactionShipping", "ga:transactionTax", "ga:transactions", "ga:searchUniques", "ga:uniquePageviews", "ga:timeOnSite", "ga:avgTimeOnSite", "ga:visits", "ga:searchVisits"};
        ANALYTICS_COLUMNS = new HashMap<String, AnalyticsColumn>();
        for (String dimensionName : dimensions) {
            ANALYTICS_COLUMNS.put(dimensionName, new AnalyticsColumn(dimensionName, ColumnType.DIMENSION));
        }
        for (String metricName : metrics) {
            ANALYTICS_COLUMNS.put(metricName, new AnalyticsColumn(metricName, ColumnType.METRIC));
        }
    }

    private static class ColumnTypeMap
    extends LinkedHashMap<Integer, AnalyticsColumn> {
        private ColumnTypeMap() {
        }

        String getColumnString(ColumnType columnType) {
            LinkedList<String> columnNames = new LinkedList<String>();
            for (AnalyticsColumn c : this.values()) {
                if (c.getType() != columnType) continue;
                columnNames.add(c.getName());
            }
            return ColumnTypeMap.join(columnNames);
        }

        private static String join(List<String> strings) {
            Iterator<String> stringIterator = strings.iterator();
            if (!stringIterator.hasNext()) {
                return "";
            }
            StringBuilder s = new StringBuilder(stringIterator.next());
            while (stringIterator.hasNext()) {
                s.append(",").append(stringIterator.next());
            }
            return s.toString();
        }
    }

    private static class AnalyticsColumn {
        private final String name;
        private final ColumnType type;

        AnalyticsColumn(String name, ColumnType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ColumnType getType() {
            return this.type;
        }
    }

    private static enum ColumnType {
        DIMENSION,
        METRIC;

    }
}

