/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeoJSONTableModel
extends AbstractTableModel {
    private GeometryFactory geometryFactory = new GeometryFactory();
    private String[] labels;
    private Class[] classes;
    private JSONArray array;
    private boolean hasGeo = false;

    public GeoJSONTableModel(InputStream is) throws IOException {
        String str = IOUtils.toString((InputStream)is);
        try {
            Object feature;
            JSONObject root = new JSONObject(str);
            this.array = root.getJSONArray("features");
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < this.array.length(); ++i) {
                feature = this.array.getJSONObject(i);
                JSONObject properties = feature.getJSONObject("properties");
                for (String key : JSONObject.getNames((JSONObject)properties)) {
                    keys.add(key);
                }
                if (this.hasGeo) continue;
                this.hasGeo = feature.has("geometry");
            }
            if (this.hasGeo) {
                keys.add("geometry");
            }
            this.labels = new String[keys.size()];
            int index = 0;
            feature = keys.iterator();
            while (feature.hasNext()) {
                String key;
                this.labels[index] = key = (String)feature.next();
                ++index;
            }
            this.classes = new Class[keys.size()];
            for (int i = 0; i < this.classes.length; ++i) {
                this.classes[i] = Object.class;
            }
            if (this.hasGeo) {
                this.classes[this.classes.length - 1] = Geometry.class;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.labels[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.array.length();
    }

    @Override
    public int getColumnCount() {
        return this.labels.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (this.hasGeo && columnIndex == this.labels.length - 1) {
                JSONObject feature = this.array.getJSONObject(rowIndex);
                if (feature.has("geometry")) {
                    JSONObject jsonObject = feature.getJSONObject("geometry");
                    Geometry geometry = null;
                    try {
                        geometry = this.parseGeometry(jsonObject);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    return geometry;
                }
                return null;
            }
            JSONObject jsonObject = this.array.getJSONObject(rowIndex).getJSONObject("properties");
            if (jsonObject.has(this.labels[columnIndex])) {
                Object value = jsonObject.get(this.labels[columnIndex]);
                if (value == JSONObject.NULL) {
                    return null;
                }
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    Object[] a = new Object[array.length()];
                    for (int i = 0; i < array.length(); ++i) {
                        a[i] = array.get(i);
                    }
                    return a;
                }
                return value;
            }
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Geometry parseGeometry(JSONObject obj) throws IllegalArgumentException {
        if (!obj.has("type")) {
            throw new UnsupportedOperationException("no type attribute");
        }
        String type = obj.getString("type");
        if (type.equalsIgnoreCase("Point")) {
            return this.parsePoint(obj);
        }
        if (type.equalsIgnoreCase("LineString")) {
            return this.parseLineString(obj);
        }
        if (type.equalsIgnoreCase("Polygon")) {
            return this.parsePolygon(obj);
        }
        if (type.equalsIgnoreCase("MultiPoint")) {
            return this.parseMultiPoint(obj);
        }
        if (type.equalsIgnoreCase("MultiLineString")) {
            return this.parseMultiLineString(obj);
        }
        if (type.equalsIgnoreCase("MultiPolygon")) {
            return this.parseMultiPolygon(obj);
        }
        if (type.equalsIgnoreCase("GeometryCollection")) {
            return this.parseGeometryCollection(obj);
        }
        throw new IllegalArgumentException(type);
    }

    private Point parsePoint(JSONObject obj) {
        return this.parseCoordinatePoint(obj.getJSONArray("coordinates"));
    }

    private LineString parseLineString(JSONObject obj) {
        return this.parseCoordinateLineString(obj.getJSONArray("coordinates"));
    }

    private Polygon parsePolygon(JSONObject obj) {
        return this.parseCoordinatePolygon(obj.getJSONArray("coordinates"));
    }

    private MultiPoint parseMultiPoint(JSONObject obj) {
        return this.geometryFactory.createMultiPoint(this.parseCoordinates(obj.getJSONArray("coordinates")));
    }

    private MultiLineString parseMultiLineString(JSONObject obj) {
        JSONArray c = obj.getJSONArray("coordinates");
        LineString[] lines = new LineString[c.length()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = this.parseCoordinateLineString(c.getJSONArray(i));
        }
        return this.geometryFactory.createMultiLineString(lines);
    }

    private MultiPolygon parseMultiPolygon(JSONObject obj) {
        JSONArray _c = obj.getJSONArray("coordinates");
        Polygon[] polys = new Polygon[_c.length()];
        for (int i = 0; i < polys.length; ++i) {
            polys[i] = this.parseCoordinatePolygon(_c.getJSONArray(i));
        }
        return this.geometryFactory.createMultiPolygon(polys);
    }

    private Envelope parseBox(JSONObject obj) {
        Coordinate[] _pts = this.parseCoordinates(obj.getJSONArray("coordinates"));
        if (_pts.length != 2) {
            throw new IndexOutOfBoundsException();
        }
        return new Envelope(_pts[0], _pts[1]);
    }

    private GeometryCollection parseGeometryCollection(JSONObject obj) {
        if (!obj.getString("type").equals("GeometryCollection")) {
            throw new UnsupportedOperationException("Not GeometryCollection type");
        }
        JSONArray _list = obj.has("members") ? obj.getJSONArray("members") : obj.getJSONArray("geometries");
        Geometry[] cols = new Geometry[_list.length()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.parseGeometry(_list.getJSONObject(i));
        }
        return this.geometryFactory.createGeometryCollection(cols);
    }

    private Coordinate parseCoordinate(JSONArray obj) {
        if (obj.length() < 2) {
            throw new IndexOutOfBoundsException("Not enough coordinates");
        }
        return new Coordinate(obj.getDouble(0), obj.getDouble(1));
    }

    private Coordinate[] parseCoordinates(JSONArray obj) {
        Coordinate[] cs = new Coordinate[obj.length()];
        for (int i = 0; i < obj.length(); ++i) {
            cs[i] = this.parseCoordinate(obj.getJSONArray(i));
        }
        return cs;
    }

    private Point parseCoordinatePoint(JSONArray obj) {
        return this.geometryFactory.createPoint(this.parseCoordinate(obj));
    }

    private LineString parseCoordinateLineString(JSONArray obj) {
        return this.geometryFactory.createLineString(this.parseCoordinates(obj));
    }

    private LinearRing parseCoordinateLineRing(JSONArray obj) {
        return this.geometryFactory.createLinearRing(this.parseCoordinates(obj));
    }

    private Polygon parseCoordinatePolygon(JSONArray obj) {
        if (obj.length() < 0) {
            throw new IndexOutOfBoundsException("Not enough line string");
        }
        LinearRing _out = this.parseCoordinateLineRing(obj.getJSONArray(0));
        LinearRing[] inners = new LinearRing[obj.length() - 1];
        for (int i = 0; i < inners.length; ++i) {
            inners[i] = this.parseCoordinateLineRing(obj.getJSONArray(i + 1));
        }
        return this.geometryFactory.createPolygon(_out, inners);
    }
}

