/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.data.type.StringDouble;
import com.macrofocus.data.type.StringLong;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TcpdumpTableModel
extends AbstractTableModel {
    private static final Pattern hostPortPattern = Pattern.compile("^\\s*(.*?).(\\d+)\\s*$");
    private static final Pattern seqnoPattern = Pattern.compile("(\\d+):(\\d+).(\\d+)\\)");
    private static final Pattern timePattern = Pattern.compile("(\\d+):(\\d+):(\\d+).(\\d+)");
    private List<Connection> connections = new ArrayList<Connection>();

    public TcpdumpTableModel(BufferedInputStream bis) throws IOException {
        HashMap<ICMPPacket, Connection> treeMap = new HashMap<ICMPPacket, Connection>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(bis));
        while (reader.ready()) {
            Connection connection;
            AbstractPacket packet;
            String line = reader.readLine();
            Scanner scanner = new Scanner(line);
            String time = scanner.next();
            Matcher timeMatcher = timePattern.matcher(time);
            StringDouble t = null;
            if (timeMatcher.matches()) {
                double hr = Integer.parseInt(timeMatcher.group(1));
                double min = Integer.parseInt(timeMatcher.group(2));
                double secs = Integer.parseInt(timeMatcher.group(3));
                double ms = Integer.parseInt(timeMatcher.group(4));
                t = new StringDouble(hr * 3600.0 + min * 60.0 + secs + ms / 1000000.0, time);
            } else {
                System.err.println("Couldn't parse time " + time);
            }
            String from = scanner.next();
            scanner.next();
            String to = scanner.next();
            to = to.substring(0, to.length() - 1);
            String flag = scanner.next();
            if (from.endsWith(".") || from.split(".").length == 4) {
                packet = new ICMPPacket(from, to, t);
            } else if ("udp".equals(flag)) {
                int bytes = scanner.nextInt();
                packet = new UDPPacket(from, to, t, bytes);
            } else {
                int bytes = 0;
                String seqno = scanner.next();
                if (!"ack".equals(seqno)) {
                    Matcher m = seqnoPattern.matcher(seqno);
                    if (m.matches()) {
                        bytes = Integer.parseInt(m.group(3));
                    } else {
                        System.out.println(seqno + " does not match. flag = " + flag);
                    }
                }
                int win = -1;
                while (scanner.hasNext()) {
                    if (scanner.hasNext("win")) {
                        scanner.next();
                        win = scanner.nextInt();
                        continue;
                    }
                    scanner.next();
                }
                if (flag.length() > 2 || flag.length() > 0 && Character.isDigit(flag.charAt(0))) {
                    flag = null;
                }
                packet = new TCPPacket(from, to, t, bytes, flag);
            }
            if (treeMap.containsKey(packet)) {
                connection = (Connection)treeMap.get(packet);
                connection.addPacket(packet);
                treeMap.remove(packet);
                treeMap.put((ICMPPacket)packet, connection);
                continue;
            }
            connection = new Connection(packet);
            treeMap.put((ICMPPacket)packet, connection);
            this.connections.add(connection);
        }
        reader.close();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "From";
            }
            case 1: {
                return "To";
            }
            case 2: {
                return "Start";
            }
            case 3: {
                return "End";
            }
            case 4: {
                return "src_addr";
            }
            case 5: {
                return "src_port";
            }
            case 6: {
                return "dest_addr";
            }
            case 7: {
                return "dest_port";
            }
            case 8: {
                return "type";
            }
            case 9: {
                return "Packets";
            }
            case 10: {
                return "Bytes";
            }
            case 11: {
                return "Sent bytes";
            }
            case 12: {
                return "Rcvd bytes";
            }
            case 13: {
                return "Direction";
            }
            case 14: {
                return "First Flag";
            }
            case 15: {
                return "Last Flag";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Number.class;
            }
            case 3: {
                return Number.class;
            }
            case 4: {
                return Number.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Number.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return Integer.class;
            }
            case 10: {
                return Long.class;
            }
            case 11: {
                return Long.class;
            }
            case 12: {
                return Long.class;
            }
            case 13: {
                return String.class;
            }
            case 14: {
                return String.class;
            }
            case 15: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.connections.size();
    }

    @Override
    public int getColumnCount() {
        return 16;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Connection connection = this.connections.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return connection.first.getFrom();
            }
            case 1: {
                return connection.first.getTo();
            }
            case 2: {
                return connection.first.getTime();
            }
            case 3: {
                return connection.last.getTime();
            }
            case 4: {
                return connection.first.getSrcAddr();
            }
            case 5: {
                return connection.first.getSrcPort();
            }
            case 6: {
                return connection.first.getDestAddr();
            }
            case 7: {
                return connection.first.getDestPort();
            }
            case 8: {
                return connection.first.getType();
            }
            case 9: {
                return connection.getPackets();
            }
            case 10: {
                return connection.getSentBytes() + connection.getRcvdBytes();
            }
            case 11: {
                return connection.getSentBytes();
            }
            case 12: {
                return connection.getRcvdBytes();
            }
            case 13: {
                return connection.getDirection();
            }
            case 14: {
                return connection.getFirstFlag();
            }
            case 15: {
                return connection.getLastFlag();
            }
        }
        return null;
    }

    public static long parseIp(String address) {
        long result = 0L;
        for (String part : address.split(Pattern.quote("."))) {
            result <<= 8;
            result |= Long.parseLong(part);
        }
        return result;
    }

    private class ICMPPacket
    extends AbstractPacket {
        private ICMPPacket(String from, String to, Number time) {
            super(from + "0", to + ".0", time);
        }

        @Override
        public String getType() {
            return "icmp";
        }
    }

    private class UDPPacket
    extends AbstractPacket {
        private int bytes;

        private UDPPacket(String from, String to, Number time, int bytes) {
            super(from, to, time);
            this.bytes = bytes;
        }

        public int getBytes() {
            return this.bytes;
        }

        @Override
        public String getType() {
            return "udp";
        }
    }

    private class TCPPacket
    extends AbstractPacket {
        private int bytes;
        private String flag;

        private TCPPacket(String from, String to, Number time, int bytes, String flag) {
            super(from, to, time);
            this.bytes = bytes;
            this.flag = flag;
        }

        public int getBytes() {
            return this.bytes;
        }

        @Override
        public String getType() {
            return "tcp";
        }
    }

    private class Connection {
        private Packet first;
        private Packet last;
        int packets = 1;
        long sentBytes = 0L;
        long rcvdBytes = 0L;

        private Connection(Packet first) {
            this.first = first;
            this.last = first;
        }

        public Packet getLast() {
            return this.last;
        }

        public int getPackets() {
            return this.packets;
        }

        public long getSentBytes() {
            return this.sentBytes;
        }

        public long getRcvdBytes() {
            return this.rcvdBytes;
        }

        public String getDirection() {
            if (this.first.getFrom().startsWith("1.0.256.256")) {
                if (this.first.getTo().startsWith("1.0.256.256")) {
                    return "internal";
                }
                return "outbound";
            }
            if (this.first.getTo().startsWith("1.0.256.256")) {
                return "inbound";
            }
            return "external";
        }

        public String getFirstFlag() {
            if (this.first instanceof TCPPacket) {
                return ((TCPPacket)this.first).flag;
            }
            return null;
        }

        public String getLastFlag() {
            if (this.last instanceof TCPPacket) {
                return ((TCPPacket)this.last).flag;
            }
            return null;
        }

        public void addPacket(Packet last) {
            this.last = last;
            if (last instanceof UDPPacket) {
                UDPPacket udp = (UDPPacket)last;
                if (last.getFrom().equals(this.first.getFrom())) {
                    this.sentBytes += (long)udp.getBytes();
                } else {
                    this.rcvdBytes += (long)udp.getBytes();
                }
            } else if (last instanceof TCPPacket) {
                TCPPacket udp = (TCPPacket)last;
                if (last.getFrom().equals(this.first.getFrom())) {
                    this.sentBytes += (long)udp.getBytes();
                } else {
                    this.rcvdBytes += (long)udp.getBytes();
                }
            }
            ++this.packets;
        }
    }

    private static interface Packet {
        public String getType();

        public String getFrom();

        public String getTo();

        public Number getTime();

        public Number getSrcAddr();

        public int getSrcPort();

        public Number getDestAddr();

        public int getDestPort();
    }

    private abstract class AbstractPacket
    implements Packet {
        String from;
        String to;
        Number time;
        Number src_addr;
        int src_port;
        Number dest_addr;
        int dest_port;

        private AbstractPacket(String from, String to, Number time) {
            int port;
            String host;
            this.from = from;
            this.to = to;
            this.time = time;
            Matcher m = hostPortPattern.matcher(from);
            if (m.matches()) {
                host = m.group(1);
                port = Integer.parseInt(m.group(2));
                this.src_addr = new StringLong(TcpdumpTableModel.parseIp(host), host);
                this.src_port = port;
            }
            if ((m = hostPortPattern.matcher(to)).matches()) {
                host = m.group(1);
                port = Integer.parseInt(m.group(2));
                this.dest_addr = new StringLong(TcpdumpTableModel.parseIp(host), host);
                this.dest_port = port;
            }
        }

        @Override
        public String getFrom() {
            return this.from;
        }

        @Override
        public String getTo() {
            return this.to;
        }

        @Override
        public Number getTime() {
            return this.time;
        }

        @Override
        public Number getSrcAddr() {
            return this.src_addr;
        }

        @Override
        public int getSrcPort() {
            return this.src_port;
        }

        @Override
        public Number getDestAddr() {
            return this.dest_addr;
        }

        @Override
        public int getDestPort() {
            return this.dest_port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractPacket)) {
                return false;
            }
            AbstractPacket packet = (AbstractPacket)o;
            if (this.getClass() != o.getClass()) {
                return false;
            }
            if (this.from.equals(packet.from)) {
                return this.to.equals(packet.to);
            }
            if (this.to.equals(packet.from)) {
                return this.from.equals(packet.to);
            }
            return false;
        }

        public int hashCode() {
            int result = this.from.hashCode();
            return result += this.to.hashCode();
        }
    }
}

