/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.DuplicableNumericalTimeSeries;
import com.macrofocus.data.type.timeseries.NumericalTimeSeries;

public class RegularNumericalTimeSeries<T extends Number>
implements DuplicableNumericalTimeSeries<T> {
    private T[] values;
    private Long start;
    private Long increment;
    private T minValue;
    private T maxValue;
    private Class<? extends T> type;

    public RegularNumericalTimeSeries(Class<? extends T> type, Long start, long increment) {
        assert (Number.class.isAssignableFrom(type)) : "Invalid type " + String.valueOf(type);
        this.type = type;
        this.start = start;
        this.increment = increment;
    }

    @Override
    public NumericalTimeSeries<T> duplicate(T[] values) {
        RegularNumericalTimeSeries<? extends T> timeSeries = new RegularNumericalTimeSeries<T>(this.type, this.start, this.increment);
        timeSeries.setValues((Number[])values);
        return timeSeries;
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public long getTime(int index) {
        return this.start + (long)index * this.increment;
    }

    @Override
    public T getValue(int index) {
        return this.values[index];
    }

    @Override
    public int getItemCount() {
        return this.values.length;
    }

    @Override
    public long getMinTime() {
        return this.start;
    }

    @Override
    public long getMaxTime() {
        return this.start + (long)this.values.length * this.increment;
    }

    public void setValues(T[] values) {
        this.values = values;
        for (int i = 0; i < values.length; ++i) {
            T value = values[i];
            if (this.minValue == null || ((Number)value).doubleValue() < ((Number)this.minValue).doubleValue()) {
                this.minValue = value;
            }
            if (this.maxValue != null && !(((Number)value).doubleValue() > ((Number)this.maxValue).doubleValue())) continue;
            this.maxValue = value;
        }
    }

    @Override
    public T getMinValue() {
        return this.minValue;
    }

    @Override
    public T getMaxValue() {
        return this.maxValue;
    }
}

