/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.persistence.json;

import com.macrofocus.persistence.Attribute;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.Elements;
import com.macrofocus.persistence.json.JSONElements;
import com.macrofocus.persistence.json.JSONObjectAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONObjectElement
implements Element {
    private final JSONObject jsonObject;
    private final String name;

    public JSONObjectElement(JSONObject jsonObject, String name) {
        this.jsonObject = jsonObject;
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public int getAttributeCount() {
        return this.getAttributes().size();
    }

    public Attribute getAttribute(int index) {
        return this.getAttribute(this.getAttributes().get(index));
    }

    public Attribute getAttribute(String key) {
        if (this.jsonObject.getJSONObject(this.name).has(key)) {
            JSONObject jsonObject = this.jsonObject.getJSONObject(this.name);
            return new JSONObjectAttribute(jsonObject, key);
        }
        return null;
    }

    private List<String> getAttributes() {
        JSONObject jsonObject = this.jsonObject.getJSONObject(this.name);
        ArrayList<String> children = new ArrayList<String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object o = jsonObject.get((String)key);
            if (o instanceof JSONObject || o instanceof JSONArray) continue;
            children.add((String)key);
        }
        return children;
    }

    public Elements getChildElements() {
        return new JSONElements(this.jsonObject.getJSONObject(this.name));
    }

    public String getAttributeValue(String key) {
        Attribute attribute = this.getAttribute(key);
        return attribute != null ? attribute.getValue() : null;
    }

    public void addAttribute(Attribute attribute) {
    }

    public void appendChild(Element element) {
    }
}

