/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.file.filter;

import com.macrofocus.util.file.filter.AbstractFileFilter;

public class MicrosoftExcelFileFilter
extends AbstractFileFilter {
    private String[] extensions = new String[]{"xls", "xlsx", "xlsm"};

    public MicrosoftExcelFileFilter() {
    }

    public MicrosoftExcelFileFilter(boolean allowDirectories) {
        super(allowDirectories);
    }

    @Override
    public String getDefaultExtension() {
        return this.extensions[0];
    }

    @Override
    public String[] getExtensions() {
        return this.extensions;
    }

    @Override
    public String getName() {
        return "Microsoft Excel Workbook";
    }

    @Override
    public boolean acceptContentType(String contentType) {
        return "application/vnd.ms-excel".equalsIgnoreCase(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equalsIgnoreCase(contentType);
    }
}

