/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.minmax;

import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.util.minmax.MinmaxModel;

public class StdDevMinmaxModel
implements MinmaxModel {
    private double rangeMin;
    private double rangeMax;
    private double avg;
    private double stdev;
    private double count;

    public StdDevMinmaxModel(MatrixModel matrixModel, Object column) {
        double value;
        int row;
        int columnIndex = matrixModel.getColumnIndex(column);
        for (row = 0; row < matrixModel.getRowCount(); ++row) {
            if (!matrixModel.isAvailable(row, columnIndex)) continue;
            value = matrixModel.getDouble(row, columnIndex);
            if (value < this.rangeMin) {
                this.rangeMin = value;
            }
            if (!(value > this.rangeMax)) continue;
            this.rangeMax = value;
        }
        this.avg = 0.0;
        this.stdev = 0.0;
        this.count = 0.0;
        for (row = 0; row < matrixModel.getRowCount(); ++row) {
            if (!matrixModel.isAvailable(row, columnIndex)) continue;
            value = matrixModel.getDouble(row, columnIndex);
            this.avg += value;
            this.count += 1.0;
        }
        this.avg /= this.count;
        double squareSum = 0.0;
        for (int row2 = 0; row2 < matrixModel.getRowCount(); ++row2) {
            double sum = 0.0;
            if (!matrixModel.isAvailable(row2, columnIndex)) continue;
            double value2 = matrixModel.getDouble(row2, columnIndex);
            squareSum += Math.pow(value2 - this.avg, 2.0);
            sum += value2;
        }
        this.stdev = Math.sqrt(squareSum / this.count);
        double stdRangeMin = this.avg - 2.0 * this.stdev;
        double stdRangeMax = this.avg + 2.0 * this.stdev;
        if (stdRangeMax < this.rangeMax) {
            this.rangeMax = stdRangeMax;
        }
        if (stdRangeMin > this.rangeMin) {
            this.rangeMin = stdRangeMin;
        }
    }

    @Override
    public double getMinimum() {
        return this.rangeMin;
    }

    @Override
    public double getMaximum() {
        return this.rangeMax;
    }
}

