/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.controls;

import java.awt.event.KeyEvent;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.DefaultFormatterFactory;

public abstract class AbstractComboBoxEditor
extends BasicComboBoxEditor {
    private CellEditor cellEditor;

    public AbstractComboBoxEditor(ComboBoxEditor defaultEditor, CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        this.editor = this.createComboBoxEditorComponent();
    }

    protected JTextField createComboBoxEditorComponent() {
        JFormattedTextField c = new JFormattedTextField(){

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                boolean validBinding = super.processKeyBinding(ks, e, condition, pressed);
                CellEditor cellEditor = AbstractComboBoxEditor.this.cellEditor;
                if (cellEditor != null) {
                    boolean isEscape;
                    boolean isEnter;
                    boolean bl = isEnter = ks == KeyStroke.getKeyStroke(10, 0);
                    if (isEnter && this.isEnabled() && validBinding) {
                        cellEditor.stopCellEditing();
                    }
                    boolean bl2 = isEscape = ks == KeyStroke.getKeyStroke(27, 0);
                    if (isEscape && this.isEnabled() && validBinding) {
                        return false;
                    }
                }
                return validBinding;
            }
        };
        c.setFormatterFactory(new DefaultFormatterFactory(this.createFormatter()));
        c.setName("ComboBox.textField");
        return c;
    }

    @Override
    public void setItem(Object object) {
        ((JFormattedTextField)this.editor).setValue(object);
    }

    @Override
    public Object getItem() {
        return ((JFormattedTextField)this.editor).getValue();
    }

    protected abstract JFormattedTextField.AbstractFormatter createFormatter();
}

