/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane.ui.controls;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.tabpane.ui.BasicJYTabbedPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class JYTabbedPaneLayout
extends BorderLayout
implements SwingConstants {
    private static final long serialVersionUID = 7748703031702632025L;
    private JYTabbedPane tabPane;
    private BasicJYTabbedPaneUI ui;

    static {
        $SWITCH_TABLE$de$javasoft$tabpane$JYTabbedPane$TabControlsShowStrategy = JYTabbedPaneLayout.$SWITCH_TABLE$de$javasoft$tabpane$JYTabbedPane$TabControlsShowStrategy();
    }

    public JYTabbedPaneLayout(JYTabbedPane tabPane, BasicJYTabbedPaneUI ui) {
        this.ui = ui;
        this.tabPane = tabPane;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        super.addLayoutComponent(comp, constraints);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateSize(false);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateSize(true);
    }

    protected Dimension calculateSize(boolean minimum) {
        int tabPlacement = this.tabPane.getTabPlacement();
        Insets insets = this.tabPane.getInsets();
        Insets contentInsets = this.ui.getContentBorderInsets(tabPlacement);
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        Dimension zeroSize = new Dimension(0, 0);
        int height = 0;
        int width = 0;
        int cWidth = 0;
        int cHeight = 0;
        int i = 0;
        while (i < this.tabPane.getTabCount()) {
            Component component = this.tabPane.getComponentAt(i);
            if (component != null) {
                Dimension size = zeroSize;
                Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                if (size != null) {
                    cHeight = Math.max(size.height, cHeight);
                    cWidth = Math.max(size.width, cWidth);
                }
            }
            ++i;
        }
        width += cWidth;
        height += cHeight;
        int tabExtent = 0;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                height = Math.max(height, this.ui.calculateMaxTabHeight(tabPlacement));
                tabExtent = this.preferredTabAreaWidth(tabPlacement, tabAreaInsets);
                width += tabExtent;
                break;
            }
            default: {
                width = Math.max(width, this.ui.calculateMaxTabWidth(tabPlacement));
                tabExtent = this.preferredTabAreaHeight(tabPlacement, tabAreaInsets);
                height += tabExtent;
            }
        }
        return new Dimension(width + insets.left + insets.right + contentInsets.left + contentInsets.right, height + insets.bottom + insets.top + contentInsets.top + contentInsets.bottom);
    }

    protected int preferredTabAreaHeight(int tabPlacement, Insets tabAreaInsets) {
        return this.ui.calculateMaxTabHeight(tabPlacement) + tabAreaInsets.top + tabAreaInsets.bottom;
    }

    protected int preferredTabAreaWidth(int tabPlacement, Insets tabAreaInsets) {
        return this.ui.calculateMaxTabWidth(tabPlacement) + tabAreaInsets.top + tabAreaInsets.bottom;
    }

    private void updateControlsPanelVisibility() {
        int currentSize;
        int neededSize;
        BasicJYTabbedPaneUI.TabsPanel tabsPanel = this.ui.getTabsPanel();
        BasicJYTabbedPaneUI.TabsPanelViewport tabsPanelViewport = this.ui.getTabsPanelViewport();
        JPanel leadingTabControlsPanel = this.ui.getLeadingTabControlsPanel();
        JPanel trailingTabControlsPanel = this.ui.getTrailingTabControlsPanel();
        int buttonWidth = leadingTabControlsPanel.getWidth() + trailingTabControlsPanel.getWidth();
        int buttonHeight = leadingTabControlsPanel.getHeight() + trailingTabControlsPanel.getHeight();
        boolean buttonVisible = leadingTabControlsPanel.isVisible() | trailingTabControlsPanel.isVisible();
        boolean vertical = this.tabPane.getTabPlacement() == 2 || this.tabPane.getTabPlacement() == 4;
        int n = neededSize = vertical ? tabsPanel.getPreferredSize().height : tabsPanel.getPreferredSize().width;
        int n2 = vertical ? tabsPanelViewport.getSize().height + (buttonVisible ? buttonHeight : 0) : (currentSize = tabsPanelViewport.getSize().width + (buttonVisible ? buttonWidth : 0));
        if (this.tabPane.getTabOverviewEnabled().booleanValue()) {
            AbstractButton overviewButton = (AbstractButton)SyntheticaLookAndFeel.findComponent((String)"JYTabbedPane.TabOverviewButton", (Container)leadingTabControlsPanel);
            currentSize -= overviewButton == null ? 0 : (vertical ? overviewButton.getHeight() : overviewButton.getWidth());
        }
        boolean visible = currentSize < neededSize;
        switch (this.tabPane.getTabControlsShowStrategy()) {
            case ALWAYS: {
                visible = true;
                break;
            }
            case NEVER: {
                visible = false;
            }
        }
        this.ui.updateTabControls(this.tabPane.getTabControlsPosition(), visible & this.tabPane.getShowScrollButtons(), visible & this.tabPane.getShowPopupButton(), this.tabPane.getTabOverviewEnabled());
    }

    @Override
    public void layoutContainer(Container parent) {
        this.ui.updateTabCloseButtons();
        this.ui.updateTabFontStyle();
        BasicJYTabbedPaneUI.TabsPanel tabsPanel = this.ui.getTabsPanel();
        this.updateControlsPanelVisibility();
        int selectedIndex = this.tabPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            Component selectedComponent = this.tabPane.getComponentAt(selectedIndex);
            Component[] componentArray = this.tabPane.getContentPanel().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (selectedComponent == c && !c.isVisible()) {
                    c.setVisible(true);
                } else if (selectedComponent != c && c.isVisible()) {
                    c.setVisible(false);
                }
                ++n2;
            }
        }
        super.layoutContainer(parent);
        tabsPanel.updateTabRects();
    }
}

