/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.xmenu.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.xmenu.XMenu;
import de.javasoft.xmenu.ui.BasicXMenuUI;
import de.javasoft.xmenu.ui.painter.XMenuPainter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public class SyntheticaXMenuUI
extends BasicXMenuUI {
    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaXMenuUI();
    }

    @Override
    protected void installDefaults(JComponent c) {
        super.installDefaults(c);
        Font f = c.getFont();
        if (f == null || f instanceof UIResource) {
            String style = SyntheticaLookAndFeel.getString((String)"XMenu.fontStyle", (Component)c);
            int fontStyle = style == null ? FontStyle.PLAIN.getStyleAsInt() : FontStyle.valueOf(style).getStyleAsInt();
            c.setFont(new FontUIResource(SyntheticaLookAndFeel.getFontName(), fontStyle, SyntheticaLookAndFeel.getFontSize()));
            this.menuButton.setFont(c.getFont());
        }
    }

    @Override
    protected void paintBackground(JComponent c, Graphics g, int x, int y, int w, int h) {
        SyntheticaState state = this.createState(c, ((AbstractButton)c).isSelected());
        XMenuPainter.getInstance().paintBackground(c, state, g, x, y, w, h);
    }

    @Override
    protected void paintContentPaneBackground(JComponent c, Graphics g, int x, int y, int w, int h) {
        XMenuPainter.getInstance().paintContentPaneBackground(c, new SyntheticaState(0), g, x, y, w, h);
    }

    @Override
    protected void paintButtonBackground(JComponent c, boolean selected, Graphics g, int x, int y, int w, int h) {
        SyntheticaState state = this.createState(c, !this.xMenu.isCollapsed());
        XMenuPainter.getInstance().paintButtonBackground(c, state, g, x, y, w, h);
    }

    private SyntheticaState createState(JComponent c, boolean selected) {
        AbstractButton b = (AbstractButton)c;
        SyntheticaState state = new SyntheticaState();
        if (this.isMouseSensitive() ? b.getModel().isPressed() : ((XMenu)b).getMenuButton().getModel().isPressed()) {
            state.setState(SyntheticaState.State.PRESSED);
        } else if (this.isMouseSensitive() ? b.getModel().isRollover() : ((XMenu)b).getMenuButton().getModel().isRollover()) {
            state.setState(SyntheticaState.State.HOVER);
        }
        if (selected) {
            state.setState(SyntheticaState.State.SELECTED);
        }
        if (!b.isEnabled()) {
            state.setState(SyntheticaState.State.DISABLED);
        }
        return state;
    }

    private static enum FontStyle {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        ITALIC_BOLD(3);

        private int fontStyle;

        private FontStyle(int fontStyle) {
            this.fontStyle = fontStyle;
        }

        private int getStyleAsInt() {
            return this.fontStyle;
        }
    }
}

