/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.io.IOException;
import java.io.OutputStream;
import org.json.zip.BitInputStream;
import org.json.zip.BitWriter;

public class BitOutputStream
implements BitWriter {
    private long nrBits = 0L;
    private OutputStream out;
    private int unwritten;
    private int vacant = 8;

    public BitOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public long nrBits() {
        return this.nrBits;
    }

    public void one() throws IOException {
        this.write(1, 1);
    }

    public void pad(int n) throws IOException {
        int n2 = n - (int)(this.nrBits % (long)n);
        int n3 = n2 & 7;
        if (n3 > 0) {
            this.write(0, n3);
            n2 -= n3;
        }
        while (n2 > 0) {
            this.write(0, 8);
            n2 -= 8;
        }
        this.out.flush();
    }

    public void write(int n, int n2) throws IOException {
        if (n == 0 && n2 == 0) {
            return;
        }
        if (n2 <= 0 || n2 > 32) {
            throw new IOException("Bad write width.");
        }
        while (n2 > 0) {
            int n3 = n2;
            if (n3 > this.vacant) {
                n3 = this.vacant;
            }
            this.unwritten |= (n >>> n2 - n3 & BitInputStream.mask[n3]) << this.vacant - n3;
            n2 -= n3;
            this.nrBits += (long)n3;
            this.vacant -= n3;
            if (this.vacant != 0) continue;
            this.out.write(this.unwritten);
            this.unwritten = 0;
            this.vacant = 8;
        }
    }

    public void zero() throws IOException {
        this.write(0, 1);
    }
}

