/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.batch;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.batch.IBatchInterrupted;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class BatchInterrupted
extends ExtensionPoint
implements Extension,
IBatchInterrupted {
    private String reason;
    private int totalCount;
    private int successCount;
    private int errorCount;
    private String content;
    private ContentType contentType;

    public BatchInterrupted(String reason, int totalCount, int successCount, int errorCount) {
        this.reason = reason;
        this.totalCount = totalCount;
        this.successCount = successCount;
        this.errorCount = errorCount;
        if (totalCount < successCount - errorCount) {
            throw new IllegalArgumentException("total < success + error. total = " + totalCount + " success=" + successCount + " error=" + errorCount);
        }
    }

    public BatchInterrupted() {
    }

    public BatchInterrupted(Throwable cause, int totalCount, int successCount, int errorCount) {
        this(BatchInterrupted.getReasonFromException(cause), totalCount, successCount, errorCount);
        if (cause instanceof ServiceException) {
            ServiceException se = (ServiceException)cause;
            this.content = se.getResponseBody();
            this.contentType = se.getResponseContentType();
        }
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(BatchInterrupted.class);
        desc.setNamespace(Namespaces.batchNs);
        desc.setLocalName("interrupted");
        desc.setRepeatable(false);
        return desc;
    }

    private static String getReasonFromException(Throwable cause) {
        String message = cause.getMessage();
        if (message == null) {
            return "Unexpected error";
        }
        return message;
    }

    public String getReason() {
        return this.reason;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getSkippedCount() {
        return this.totalCount - (this.successCount + this.errorCount);
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(6);
        if (this.reason != null) {
            attrs.add(new XmlWriter.Attribute("reason", this.reason));
        }
        attrs.add(new XmlWriter.Attribute("parsed", Integer.toString(this.totalCount)));
        attrs.add(new XmlWriter.Attribute("success", Integer.toString(this.successCount)));
        attrs.add(new XmlWriter.Attribute("error", Integer.toString(this.errorCount)));
        int skippedCount = this.totalCount - (this.successCount + this.errorCount);
        attrs.add(new XmlWriter.Attribute("unprocessed", Integer.toString(skippedCount)));
        if (this.contentType != null) {
            this.contentType.getAttributes().remove("charset");
            attrs.add(new XmlWriter.Attribute("content-type", this.contentType.toString()));
        }
        this.generateStartElement(w, Namespaces.batchNs, "interrupted", attrs, null);
        this.generateExtensions(w, extProfile);
        if (this.content != null) {
            w.characters(this.content);
        }
        w.endElement(Namespaces.batchNs, "interrupted");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) throws ParseException {
        return new BatchInterruptedElementHandler(extProfile, attrs);
    }

    private static int getIntegerAttribute(Attributes attrs, String name, int defValue) throws ParseException {
        String stringValue = attrs.getValue(name);
        if (stringValue == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidIntegerAttribute, (Throwable)e);
            pe.setInternalReason("Invalid integer in value of attribute " + name + ": '" + stringValue + "'");
            throw pe;
        }
    }

    private class BatchInterruptedElementHandler
    extends ExtensionPoint.ExtensionHandler {
        public BatchInterruptedElementHandler(ExtensionProfile extProfile, Attributes attrs) throws ParseException {
            super(extProfile, BatchInterrupted.class);
            BatchInterrupted.this.totalCount = BatchInterrupted.getIntegerAttribute(attrs, "parsed", 0);
            BatchInterrupted.this.successCount = BatchInterrupted.getIntegerAttribute(attrs, "success", 0);
            BatchInterrupted.this.errorCount = BatchInterrupted.getIntegerAttribute(attrs, "error", 0);
            BatchInterrupted.this.reason = attrs.getValue("reason");
            String contentTypeString = attrs.getValue("content-type");
            if (contentTypeString != null) {
                try {
                    BatchInterrupted.this.contentType = new ContentType(contentTypeString);
                }
                catch (IllegalArgumentException e) {
                    ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidContentType, (Throwable)e);
                    pe.setInternalReason("Invalid content type: '" + contentTypeString + "'");
                    throw pe;
                }
            }
        }

        public void processEndElement() {
            BatchInterrupted.this.content = this.value;
        }
    }
}

