/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.tsne;

import com.macrofocus.high_d.mds.tsne.AbstractMatrixOperations;
import com.macrofocus.high_d.mds.tsne.MatrixOperations;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.ThreadLocalRandom;

class JavaMatrixOperations
extends AbstractMatrixOperations {
    private static final ForkJoinPool pool = new ForkJoinPool();
    private final MatrixOperations.MatrixOp multiplyop = new MatrixOperations.MatrixOp(){

        public double compute(double f1, double f2) {
            return f1 * f2;
        }
    };
    private final MatrixOperations.MatrixOp minusop = new MatrixOperations.MatrixOp(){

        public double compute(double f1, double f2) {
            return f1 - f2;
        }
    };

    JavaMatrixOperations() {
    }

    public double dnrom(double mu, double sigma) {
        return mu + ThreadLocalRandom.current().nextGaussian() * sigma;
    }

    public double[][] transpose(double[][] matrix) {
        return this.transpose(matrix, 1000);
    }

    public double[][] transpose(double[][] matrix, int ll) {
        int cols = matrix[0].length;
        int rows = matrix.length;
        double[][] transpose = new double[cols][rows];
        if (rows < 100) {
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    transpose[i][j] = matrix[j][i];
                }
            }
        } else {
            MatrixTransposer process = new MatrixTransposer(matrix, transpose, 0, rows, ll);
            pool.invoke(process);
        }
        return transpose;
    }

    public double[][] scalarMultiply(double[][] m1, double[][] m2) {
        return this.parScalarMultiply(m1, m2);
    }

    public double[][] parScalarMultiply(double[][] m1, double[][] m2) {
        int ll = 600;
        double[][] result = new double[m1.length][m1[0].length];
        MatrixOperator process = new MatrixOperator(m1, m2, result, this.multiplyop, 0, m1.length, ll);
        pool.invoke(process);
        return result;
    }

    public double[][] minus(double[][] m1, double[][] m2) {
        return this.parScalarMinus(m1, m2);
    }

    public double[][] parScalarMinus(double[][] m1, double[][] m2) {
        int ll = 600;
        double[][] result = new double[m1.length][m1[0].length];
        MatrixOperator process = new MatrixOperator(m1, m2, result, this.minusop, 0, m1.length, ll);
        pool.invoke(process);
        return result;
    }

    private class MatrixTransposer
    extends RecursiveAction {
        final double[][] orig;
        final double[][] transpose;
        int startRow = -1;
        int endRow = -1;
        int limit = 1000;

        MatrixTransposer(double[][] orig, double[][] transpose, int startRow, int endRow, int ll) {
            this.limit = ll;
            this.orig = orig;
            this.transpose = transpose;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        protected void compute() {
            try {
                if (this.endRow - this.startRow <= this.limit) {
                    int cols = this.orig[0].length;
                    for (int i = 0; i < cols; ++i) {
                        for (int j = this.startRow; j < this.endRow; ++j) {
                            this.transpose[i][j] = this.orig[j][i];
                        }
                    }
                } else {
                    int endRow1;
                    int range = this.endRow - this.startRow;
                    int startRow1 = this.startRow;
                    int startRow2 = endRow1 = this.startRow + range / 2;
                    int endRow2 = this.endRow;
                    MatrixTransposer.invokeAll(new MatrixTransposer(this.orig, this.transpose, startRow1, endRow1, this.limit), new MatrixTransposer(this.orig, this.transpose, startRow2, endRow2, this.limit));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class MatrixOperator
    extends RecursiveAction {
        final double[][] matrix1;
        final double[][] matrix2;
        final double[][] resultMatrix;
        final MatrixOperations.MatrixOp op;
        int startRow = -1;
        int endRow = -1;
        int limit = 1000;

        MatrixOperator(double[][] matrix1, double[][] matrix2, double[][] resultMatrix, MatrixOperations.MatrixOp op, int startRow, int endRow, int ll) {
            this.op = op;
            this.limit = ll;
            this.matrix1 = matrix1;
            this.matrix2 = matrix2;
            this.resultMatrix = resultMatrix;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        protected void compute() {
            try {
                if (this.endRow - this.startRow <= this.limit) {
                    int cols = this.matrix1[0].length;
                    for (int i = this.startRow; i < this.endRow; ++i) {
                        for (int j = 0; j < cols; ++j) {
                            this.resultMatrix[i][j] = this.op.compute(this.matrix1[i][j], this.matrix2[i][j]);
                        }
                    }
                } else {
                    int endRow1;
                    int range = this.endRow - this.startRow;
                    int startRow1 = this.startRow;
                    int startRow2 = endRow1 = this.startRow + range / 2;
                    int endRow2 = this.endRow;
                    MatrixOperator.invokeAll(new MatrixOperator(this.matrix1, this.matrix2, this.resultMatrix, this.op, startRow1, endRow1, this.limit), new MatrixOperator(this.matrix1, this.matrix2, this.resultMatrix, this.op, startRow2, endRow2, this.limit));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

