/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.swing;

import com.macrofocus.high_d.axis.AxisView;
import com.macrofocus.high_d.axis.swing.SwingAxisView;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.slider.SliderView;
import com.macrofocus.slider.swing.SimpleRangeSliderController;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class AxisController<Row, C> {
    private final SwingAxisView<Row, C> view;
    private final ParallelCoordinatesView<JComponent, Color, Row, C> parallelCoordinatesView;
    private Point last;
    private boolean dragging = false;
    private boolean draggedHeader = false;

    public AxisController(final SwingAxisView view, final JButton draggable, final ParallelCoordinatesView<JComponent, Color, Row, C> parallelCoordinatesView) {
        this.view = view;
        this.parallelCoordinatesView = parallelCoordinatesView;
        new SimpleRangeSliderController((SliderView)view);
        view.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                AxisController.this.dragging = true;
                if (!event.isConsumed()) {
                    AxisController.this.redirectMouseEvent(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                AxisController.this.dragging = false;
                AxisController.this.redirectMouseEvent(event);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                if (!AxisController.this.dragging) {
                    AxisController.this.redirectMouseEvent(event);
                }
            }
        });
        view.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent event) {
                AxisController.this.redirectMouseEvent(event);
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                if (!AxisController.this.dragging || view.getModel().getInterval().isFullRange()) {
                    AxisController.this.redirectMouseEvent(event);
                }
            }
        });
        if (draggable != null) {
            draggable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    if (!event.isPopupTrigger() && parallelCoordinatesView != null) {
                        Point locationOnScreen;
                        AxisController.this.last = locationOnScreen = event.getLocationOnScreen();
                        if (locationOnScreen != null) {
                            parallelCoordinatesView.startDragging((AxisView)view);
                        }
                        AxisController.this.draggedHeader = false;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    if (!event.isPopupTrigger() && parallelCoordinatesView != null) {
                        AxisController.this.last = null;
                        parallelCoordinatesView.stopDragging((AxisView)view);
                        if (!AxisController.this.draggedHeader) {
                            parallelCoordinatesView.headerSelected((AxisView)view, event.getClickCount());
                        }
                        AxisController.this.draggedHeader = false;
                        draggable.setSelected(false);
                    }
                }
            });
            draggable.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent event) {
                    if (!event.isPopupTrigger() && parallelCoordinatesView != null) {
                        Point locationOnScreen = event.getLocationOnScreen();
                        if (AxisController.this.last != null && locationOnScreen != null) {
                            int shift = locationOnScreen.x - AxisController.this.last.x;
                            parallelCoordinatesView.dragAxisTo((AxisView)view, shift);
                            AxisController.this.draggedHeader = true;
                        }
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
        }
    }

    private void redirectMouseEvent(MouseEvent e) {
        JComponent nativeComponent = (JComponent)this.parallelCoordinatesView.getNativeComponent();
        if (nativeComponent instanceof JScrollPane) {
            nativeComponent = (JComponent)((JScrollPane)nativeComponent).getViewport().getView();
        }
        e = SwingUtilities.convertMouseEvent(e.getComponent(), e, nativeComponent);
        nativeComponent.dispatchEvent(e);
    }

    protected SwingAxisView<Row, C> getView() {
        return this.view;
    }

    ParallelCoordinatesView<JComponent, Color, Row, C> getParallelCoordinatesView() {
        return this.parallelCoordinatesView;
    }
}

