/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.swing;

import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.BoundedIntervalListener;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.high_d.axis.AlphaJLabel;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.AxisView;
import com.macrofocus.high_d.axis.swing.SwingAxisView;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.swing.AxisController;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.Timer;

public class PopupAxisController<Row, C>
extends AxisController<Row, C> {
    private int PROBING_LAYER = JLayeredPane.POPUP_LAYER;
    private int SELECTION_LAYER = JLayeredPane.POPUP_LAYER - 1;
    private int RANGE_LAYER = JLayeredPane.POPUP_LAYER - 2;
    private JLabel bubbleRangeMax;
    private JLabel bubbleRangeMin;
    private JLabel bubbleProbing;
    private JLabel bubbleSelection;
    private final Format format = NumberFormat.getInstance();
    private final Timer tooltipTimer;
    private final Timer probingTimer;
    private final Timer selectionTimer;

    public PopupAxisController(SwingAxisView view, JButton draggable, ParallelCoordinatesView parallelCoordinatesView) {
        super(view, draggable, parallelCoordinatesView);
        parallelCoordinatesView.getShowProbedValues().setValue((Object)Boolean.FALSE);
        this.tooltipTimer = new Timer(400, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupAxisController.this.showSliderValues();
            }
        });
        this.tooltipTimer.setRepeats(false);
        this.tooltipTimer.setCoalesce(true);
        this.probingTimer = new Timer(400, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupAxisController.this.showProbeValue();
            }
        });
        this.probingTimer.setRepeats(false);
        this.probingTimer.setCoalesce(true);
        this.selectionTimer = new Timer(400, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupAxisController.this.showSelectionValue();
            }
        });
        this.selectionTimer.setRepeats(false);
        this.selectionTimer.setCoalesce(true);
        this.getView().getModel().getProbing().addSingleSelectionListener(new SingleSelectionListener<Row>(){

            public void selectionChanged(SingleSelectionEvent<Row> rowSingleSelectionEvent) {
                if (PopupAxisController.this.getView().isEnabled()) {
                    if (PopupAxisController.this.bubbleProbing != null) {
                        PopupAxisController.this.bubbleProbing.setVisible(false);
                    }
                    PopupAxisController.this.probingTimer.restart();
                }
            }
        });
        this.getView().getModel().getSelection().addSelectionListener(new SelectionListener<Row>(){

            public void selectionChanged(SelectionEvent<Row> event) {
                if (PopupAxisController.this.getView().isEnabled()) {
                    if (PopupAxisController.this.bubbleSelection != null) {
                        PopupAxisController.this.bubbleSelection.setVisible(false);
                    }
                    PopupAxisController.this.selectionTimer.restart();
                }
            }
        });
        parallelCoordinatesView.addDragListener(new ParallelCoordinatesView.DragListener(){

            public void startDragging(AxisView view) {
                if (PopupAxisController.this.getView().isEnabled()) {
                    if (PopupAxisController.this.bubbleSelection != null) {
                        PopupAxisController.this.bubbleSelection.setVisible(false);
                    }
                    PopupAxisController.this.selectionTimer.restart();
                }
            }

            public void stopDragging(AxisView view) {
                if (PopupAxisController.this.getView().isEnabled()) {
                    if (PopupAxisController.this.bubbleSelection != null) {
                        PopupAxisController.this.bubbleSelection.setVisible(false);
                    }
                    PopupAxisController.this.selectionTimer.restart();
                }
            }

            public void dragAxisTo(AxisView view, int shift) {
                if (PopupAxisController.this.getView().isEnabled()) {
                    if (PopupAxisController.this.bubbleSelection != null) {
                        PopupAxisController.this.bubbleSelection.setVisible(false);
                    }
                    PopupAxisController.this.selectionTimer.restart();
                }
            }
        });
        this.getView().getModel().getScaledInterval().addBoundedIntervalListener(new BoundedIntervalListener(){

            public void boundedIntervalChanged(BoundedIntervalEvent event) {
                PopupAxisController.this.updateSliderValues();
            }
        });
        this.getView().getModel().getScaledInterval().addIntervalListener(new IntervalListener(){

            public void intervalChanged(IntervalEvent event) {
                PopupAxisController.this.updateSliderValues();
            }
        });
        this.getView().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PopupAxisController.this.getView().isEnabled()) {
                    PopupAxisController.this.tooltipTimer.start();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PopupAxisController.this.getView().isEnabled()) {
                    PopupAxisController.this.tooltipTimer.stop();
                    if (PopupAxisController.this.bubbleRangeMin != null) {
                        PopupAxisController.this.bubbleRangeMin.setVisible(false);
                    }
                    if (PopupAxisController.this.bubbleRangeMax != null) {
                        PopupAxisController.this.bubbleRangeMax.setVisible(false);
                    }
                }
            }
        });
    }

    private void showSliderValues() {
        MutableBoundedInterval sliderModel = this.getView().getModel().getInterval();
        JLayeredPane layeredPane = SwingHelper.getTopLayeredPane(this.getView());
        if (this.bubbleRangeMax == null) {
            this.bubbleRangeMax = new AlphaJLabel(this.format.format(sliderModel.getEnd()));
            this.bubbleRangeMax.setBackground(Color.gray);
            layeredPane.add(this.bubbleRangeMax, this.RANGE_LAYER, 0);
        }
        if (this.bubbleRangeMin == null) {
            this.bubbleRangeMin = new AlphaJLabel(this.format.format(sliderModel.getStart()));
            this.bubbleRangeMin.setBackground(Color.gray);
            layeredPane.add(this.bubbleRangeMin, this.RANGE_LAYER, 0);
        }
        this.updateSliderValues();
    }

    private void updateSliderValues() {
        if (this.getView().isShowing()) {
            Point p;
            Dimension size;
            double value;
            Point scrnLoc = this.getView().getLocationOnScreen();
            Rectangle minRectangle = this.getView().getMinRectangle();
            Rectangle maxRectangle = this.getView().getMaxRectangle();
            MutableBoundedInterval sliderModel = this.getView().getModel().getInterval();
            if (this.bubbleRangeMax != null) {
                value = sliderModel.getEnd();
                this.bubbleRangeMax.setText(this.getView().getModel().getFormattedCeilValue(value));
                size = this.bubbleRangeMax.getPreferredSize();
                p = SwingHelper.convertScreenLocationToParent((Container)this.bubbleRangeMax.getParent(), (int)(scrnLoc.x + this.getView().getWidth()), (int)(scrnLoc.y + maxRectangle.y));
                this.bubbleRangeMax.setVisible(sliderModel.getEnd() != sliderModel.getMaximum());
                this.bubbleRangeMax.setLocation(p);
                this.bubbleRangeMax.setSize(size);
            }
            if (this.bubbleRangeMin != null) {
                value = sliderModel.getStart();
                this.bubbleRangeMin.setText(this.getView().getModel().getFormattedFloorValue(value));
                size = this.bubbleRangeMin.getPreferredSize();
                p = SwingHelper.convertScreenLocationToParent((Container)this.bubbleRangeMin.getParent(), (int)(scrnLoc.x + this.getView().getWidth()), (int)(scrnLoc.y + minRectangle.y + minRectangle.height - size.height));
                this.bubbleRangeMin.setVisible(sliderModel.getStart() != sliderModel.getMinimum());
                this.bubbleRangeMin.setLocation(p);
                this.bubbleRangeMin.setSize(size);
            }
        }
    }

    private void showProbeValue() {
        AxisModel axisModel = this.getView().getModel();
        if (!this.getParallelCoordinatesView().getModel().getAxisHierarchy().getAxisGroup(axisModel).isCollapsed() && this.format != null && this.getView().isShowing() && axisModel.getProbing().isEnabled() && axisModel.getProbing().isActive()) {
            if (this.bubbleProbing == null) {
                this.bubbleProbing = new AlphaJLabel("");
                this.bubbleProbing.setBackground(Color.black);
                JLayeredPane layeredPane = SwingHelper.getTopLayeredPane(this.getView());
                layeredPane.add(this.bubbleProbing, this.PROBING_LAYER, 0);
            }
            this.updateProbeValue();
        } else if (this.bubbleProbing != null) {
            this.bubbleProbing.setVisible(false);
        }
    }

    private void showSelectionValue() {
        AxisModel axisModel = this.getView().getModel();
        if (!this.getParallelCoordinatesView().getModel().getAxisHierarchy().getAxisGroup(axisModel).isCollapsed() && this.format != null && this.getView().isShowing() && this.getView().getModel().getProbing().isEnabled() && this.getView().getModel().getSelection().getSelectedCount() == 1) {
            if (this.bubbleSelection == null) {
                this.bubbleSelection = new AlphaJLabel("");
                this.bubbleSelection.setBackground(Color.black);
                JLayeredPane layeredPane = SwingHelper.getTopLayeredPane(this.getView());
                layeredPane.add(this.bubbleSelection, this.SELECTION_LAYER, 0);
            }
            this.updateSelectionValue();
        } else if (this.bubbleSelection != null) {
            this.bubbleSelection.setVisible(false);
        }
    }

    private void updateProbeValue() {
        if (this.bubbleProbing != null && this.format != null && this.getView().isShowing() && this.getView().getModel().getProbing().isEnabled() && this.getView().getModel().getProbing().isActive()) {
            Object row = this.getView().getModel().getProbing().getSelected();
            if (this.getView().getModel().getValue(row) != null) {
                this.bubbleProbing.setText(this.getView().getModel().getFormattedValue(row));
                this.bubbleProbing.setForeground(Color.orange);
                this.bubbleProbing.setSize(this.bubbleProbing.getPreferredSize());
                Point scrnLoc = this.getView().getLocationOnScreen();
                if (this.getView() != null && ((Boolean)this.getParallelCoordinatesView().getTooltip().getValue()).booleanValue()) {
                    Integer y = this.getView().getLocation(row);
                    this.bubbleProbing.setVisible(y != null);
                    if (y != null) {
                        y = y > this.getView().getHeight() / 2 ? Integer.valueOf(y - (8 + this.bubbleProbing.getPreferredSize().height)) : Integer.valueOf(y + 16);
                        Point p = SwingHelper.convertScreenLocationToParent((Container)this.bubbleProbing.getParent(), (int)(scrnLoc.x + this.getView().getWidth() / 2), (int)(scrnLoc.y + y));
                        this.bubbleProbing.setLocation(p);
                    }
                } else {
                    this.bubbleProbing.setVisible(false);
                }
            } else {
                this.bubbleProbing.setVisible(false);
            }
        }
    }

    private void updateSelectionValue() {
        if (this.bubbleProbing != null && this.format != null && this.getView().isShowing() && this.getView().getModel().getProbing().isEnabled() && this.getView().getModel().getSelection().getSelectedCount() == 1) {
            Object row = this.getView().getModel().getSelection().getSelectedSet().iterator().next();
            if (this.getView().getModel().getValue(row) != null) {
                this.bubbleSelection.setText(this.getView().getModel().getFormattedValue(row));
                this.bubbleSelection.setForeground(Color.red);
                this.bubbleSelection.setSize(this.bubbleSelection.getPreferredSize());
                Point scrnLoc = this.getView().getLocationOnScreen();
                if (this.getView() != null && ((Boolean)this.getParallelCoordinatesView().getTooltip().getValue()).booleanValue()) {
                    Integer y = this.getView().getLocation(row);
                    this.bubbleSelection.setVisible(y != null);
                    if (y != null) {
                        y = y > this.getView().getHeight() / 2 ? Integer.valueOf(y - (8 + this.bubbleProbing.getPreferredSize().height)) : Integer.valueOf(y + 16);
                        Point p = SwingHelper.convertScreenLocationToParent((Container)this.bubbleSelection.getParent(), (int)(scrnLoc.x + this.getView().getWidth() / 2), (int)(scrnLoc.y + y));
                        this.bubbleSelection.setLocation(p);
                    }
                } else {
                    this.bubbleSelection.setVisible(false);
                }
            } else {
                this.bubbleSelection.setVisible(false);
            }
        }
    }
}

