/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.swing;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingCanvas;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.AbstractParallelCoordinatesComponent;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.swing.SwingITiming;
import com.macrofocus.order.MutableVisibleOrder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;

public class SwingParallelCoordinatesComponent<Row, Column>
extends AbstractParallelCoordinatesComponent<JComponent, Color, Row, Column> {
    private final JComponent nativeComponent;
    private final SwingITiming prepareTiming = new SwingITiming("Prepare");
    private final SwingITiming renderTiming = new SwingITiming("Render");

    public SwingParallelCoordinatesComponent(final ParallelCoordinatesView<?, Color, Row, Column> view, final int level) {
        super(view, (CPCanvas)new SwingCanvas(){

            public void updateColorTheme() {
                super.updateColorTheme();
                ColorTheme colorTheme = (ColorTheme)view.getColorTheme().getValue();
                if (colorTheme != null && this.getNativeComponent() != null) {
                    Color background = this.getNativeComponent().getBackground();
                    colorTheme.setBackground(SwingFactory.getInstance().createRGBAColor(background.getRed(), background.getGreen(), background.getBlue(), background.getAlpha()));
                    CPColor backgroupColor = colorTheme.getBackground();
                    if (backgroupColor != null) {
                        this.getNativeComponent().setBackground((Color)backgroupColor.getNativeColor());
                    }
                    this.getNativeComponent().setForeground((Color)colorTheme.getForeground().getNativeColor());
                }
            }
        }, (CPFactory)SwingFactory.getInstance(), level);
        this.nativeComponent = new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                int count = 0;
                for (AxisGroupModel axisGroup : view.getParallelCoordinatesLayout().getAxisGroups(level)) {
                    MutableVisibleOrder axisOrder = axisGroup.getAxisOrder();
                    count += axisOrder.size();
                }
                return new Dimension(count * (Integer)view.getColumnSize().getValue(), 0);
            }
        };
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.nativeComponent.add(((SwingCanvas)this.canvas).getNativeComponent());
        this.nativeComponent.validate();
        this.nativeComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingParallelCoordinatesComponent.this.scheduleUpdate();
                }
            }
        });
        this.setModel(view.getModel());
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    protected void refresh() {
        this.canvas.refresh();
    }

    public void waitUntilReady() {
    }

    public void reset() {
        this.canvas.refresh();
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public int getWidth() {
        return this.nativeComponent.getWidth();
    }

    public int getHeight() {
        return this.nativeComponent.getHeight();
    }

    public void repaint() {
        this.nativeComponent.repaint();
    }

    public void scheduleUpdate() {
        this.timer.restart();
        this.canvas.refresh();
    }
}

