/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix.swing;

import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingCanvas;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.high_d.scatterplotmatrix.AbstractScatterPlotMatrixComponent;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixView;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.swing.SwingITiming;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.OverlayLayout;

public class SwingScatterPlotMatrixComponent<Row, Column>
extends AbstractScatterPlotMatrixComponent<JComponent, Color, Row, Column> {
    private final JLayeredPane nativeComponent;
    private final SwingITiming prepareTiming = new SwingITiming("Prepare");
    private final SwingITiming renderTiming = new SwingITiming("Render");

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void scheduleUpdate() {
        if (this.nativeComponent.isShowing()) {
            this.timer.restart();
            this.nativeComponent.repaint();
        }
    }

    protected int getWidth() {
        return this.nativeComponent.getWidth();
    }

    protected int getHeight() {
        return this.nativeComponent.getHeight();
    }

    protected void repaint() {
        this.nativeComponent.repaint();
    }

    public SwingScatterPlotMatrixComponent(final ScatterPlotMatrixView<JComponent, Color, Row, Column> view) {
        super(view, (CPFactory)new SwingFactory(){

            public SwingCanvas createCanvas() {
                return new SwingCanvas(){

                    public void updateColorTheme() {
                        super.updateColorTheme();
                        ColorTheme colorTheme = (ColorTheme)view.getColorTheme().getValue();
                        if (colorTheme != null && this.getNativeComponent() != null) {
                            Color background = this.getNativeComponent().getBackground();
                            colorTheme.setBackground(SwingFactory.getInstance().createRGBAColor(background.getRed(), background.getGreen(), background.getBlue(), background.getAlpha()));
                            this.getNativeComponent().setBackground((Color)colorTheme.getBackground().getNativeColor());
                            this.getNativeComponent().setForeground((Color)colorTheme.getForeground().getNativeColor());
                        }
                    }
                };
            }
        });
        this.nativeComponent = new JLayeredPane(){

            @Override
            protected void paintComponent(Graphics g) {
                SwingScatterPlotMatrixComponent.this.renderTiming.start();
                g.setColor((Color)((ColorTheme)view.getColorTheme().getValue()).getBackground().getNativeColor());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                Graphics2D g2 = (Graphics2D)g;
                Object antialias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                if (((Boolean)view.getAntialiasing().getValue()).booleanValue()) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(g);
                SwingScatterPlotMatrixComponent.this.renderTiming.end();
                if (((Boolean)view.getShowTiming().getValue()).booleanValue()) {
                    SwingScatterPlotMatrixComponent.this.prepareTiming.draw((Graphics2D)g, this.getSize(), 40);
                    SwingScatterPlotMatrixComponent.this.renderTiming.draw((Graphics2D)g, this.getSize(), 25);
                }
            }
        };
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.nativeComponent.add((Component)this.canvas.getNativeComponent(), JLayeredPane.DEFAULT_LAYER);
        this.nativeComponent.setOpaque(true);
        this.nativeComponent.updateUI();
        this.nativeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingScatterPlotMatrixComponent.this.scheduleUpdate();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingScatterPlotMatrixComponent.this.scheduleUpdate();
            }
        });
        this.nativeComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingScatterPlotMatrixComponent.this.scheduleUpdate();
                }
            }
        });
        this.setModel(view.getModel());
    }

    protected void refresh() {
        if (this.nativeComponent.isShowing()) {
            super.refresh();
        }
    }
}

