/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix.swing;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.crossplatform.swing.SwingInteractiveComponent;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.CompactAxisHeaderView;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ScatterPlotMatrixComponent;
import com.macrofocus.high_d.scatterplotmatrix.AbstractScatterPlotMatrixView;
import com.macrofocus.high_d.scatterplotmatrix.swing.SwingScatterPlotMatrixComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.order.MutableVisibleOrder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class SwingScatterPlotMatrixView<Row, Column>
extends AbstractScatterPlotMatrixView<JComponent, Color, Row, Column> {
    private final SwingInteractiveComponent<ScatterPlotMatrixLayeredPane> nativeComponent;
    private final Map<AxisModel, JComponent> axisLabels = new HashMap<AxisModel, JComponent>();
    private final SwingScatterPlotMatrixComponent scatterPlotMatrixComponent;
    private int draggedLocation;
    private LicenseModel licenseModel;
    private JPanel unregisteredPanel;
    private ComponentAdapter unregisteredPanelListener;

    public SwingScatterPlotMatrixView() {
        super((CPColorFactory)SwingFactory.getInstance());
        this.nativeComponent = new SwingInteractiveComponent((JComponent)new ScatterPlotMatrixLayeredPane());
        this.scatterPlotMatrixComponent = new SwingScatterPlotMatrixComponent(this);
        ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).add((Component)this.scatterPlotMatrixComponent.getNativeComponent(), JLayeredPane.DEFAULT_LAYER);
        ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).setOpaque(true);
        ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).updateUI();
        ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingScatterPlotMatrixView.this.refresh();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingScatterPlotMatrixView.this.refresh();
            }
        });
        ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingScatterPlotMatrixView.this.refresh();
                }
            }
        });
        this.setLicenseModel(this.licenseModel);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public JLayeredPane getNativeComponent() {
        return (JLayeredPane)this.nativeComponent.getNativeComponent();
    }

    protected ScatterPlotMatrixComponent getScatterPlotMatrixComponent() {
        return this.scatterPlotMatrixComponent;
    }

    public int getWidth() {
        return ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).getWidth();
    }

    public int getHeight() {
        return ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).getHeight();
    }

    protected void refresh() {
        if (((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).isShowing()) {
            this.runLayout();
            ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).repaint();
        }
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.removeMouseListener(l);
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.removeMouseMotionListener(l);
    }

    private void runLayout() {
        this.scatterPlotMatrixComponent.getNativeComponent().setBounds(0, 0, this.getWidth(), this.getHeight());
        MutableVisibleOrder axisOrder = this.getModel().getAxisGroupModel().getAxisOrder();
        int index = 0;
        for (AxisModel axisModel : axisOrder.iterableAll()) {
            JComponent header;
            if (axisOrder.isVisible((Object)axisModel) && index < this.getModel().getAxisCount()) {
                header = this.getOrCreateHeader(axisModel);
                int i = axisOrder.indexOf((Object)axisModel);
                Double x1Location = this.getModel().getLocation(axisModel);
                Double x2Location = i + 1 < axisOrder.size() ? this.getModel().getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
                if (x1Location != null && x2Location != null) {
                    int x = (int)(x1Location * (double)this.getWidth());
                    int y = (int)(x1Location * (double)this.getHeight());
                    int width = (int)(x2Location * (double)this.getWidth()) - x;
                    int height = (int)(x2Location * (double)this.getHeight()) - y;
                    Rectangle mp = new Rectangle(x, y, width, height);
                    header.setBounds(mp);
                }
                header.setVisible(true);
                ++index;
                continue;
            }
            header = this.getHeader(axisModel);
            if (header == null) continue;
            header.setVisible(false);
        }
        ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).revalidate();
    }

    public JComponent getHeader(AxisModel axisModel) {
        return this.axisLabels.get(axisModel);
    }

    public JComponent getOrCreateHeader(AxisModel axisModel) {
        if (!this.axisLabels.containsKey(axisModel)) {
            CompactAxisHeaderView label = this.createAxisHeaderView(axisModel);
            label.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    ((ScatterPlotMatrixLayeredPane)SwingScatterPlotMatrixView.this.nativeComponent.getNativeComponent()).requestFocusInWindow(true);
                }
            });
            ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).add((Component)label, JLayeredPane.PALETTE_LAYER);
            this.axisLabels.put(axisModel, (JComponent)label);
        }
        return this.axisLabels.get(axisModel);
    }

    protected CompactAxisHeaderView createAxisHeaderView(AxisModel axisModel) {
        CompactAxisHeaderView axisHeaderView = new CompactAxisHeaderView(axisModel, true);
        axisHeaderView.setBorderPainted(false);
        return axisHeaderView;
    }

    public Object getClosestRow(int x, int y) {
        Rectangle b = this.scatterPlotMatrixComponent.getNativeComponent().getBounds();
        if (b.contains(x, y)) {
            return this.scatterPlotMatrixComponent.getClosestRow(x - b.x, y - b.y);
        }
        return null;
    }

    public List<Row> getRows(Rectangle2D rect) {
        Rectangle b = this.scatterPlotMatrixComponent.getNativeComponent().getBounds();
        if (b.contains(rect.getX(), rect.getY())) {
            return this.scatterPlotMatrixComponent.getRows((Rectangle2D)new Rectangle2D.Double(rect.getX() - b.getX(), rect.getY() - b.getY(), rect.getWidth(), rect.getHeight()));
        }
        return null;
    }

    public void setLicenseModel(LicenseModel licenseModel) {
        if (this.unregisteredPanel != null) {
            ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).removeComponentListener(this.unregisteredPanelListener);
            ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).remove(this.unregisteredPanel);
            this.unregisteredPanel = null;
            this.unregisteredPanelListener = null;
        }
        if (licenseModel == null || licenseModel.verify() != LicenseModel.State.Valid) {
            EnhancedJLabel unregisteredLabel = new EnhancedJLabel();
            unregisteredLabel.setEffect(EnhancedLabel.Effect.Outline);
            String message = licenseModel == null ? "Unregistered version" : licenseModel.verify().toString();
            unregisteredLabel.setText(message);
            unregisteredLabel.setForeground(new Color(0, 0, 0, 63));
            unregisteredLabel.setBackground(new Color(255, 255, 255));
            unregisteredLabel.setEffectOpacity(0.2f);
            this.unregisteredPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g2);
                }
            };
            this.unregisteredPanel.setOpaque(false);
            this.unregisteredPanel.setLayout(new OverlayLayout(this.unregisteredPanel));
            this.unregisteredPanel.add((Component)unregisteredLabel);
            unregisteredLabel.setFont(unregisteredLabel.getFont().deriveFont(1, 32.0f));
            ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).add(this.unregisteredPanel, JLayeredPane.MODAL_LAYER, 0);
            this.unregisteredPanelListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingHelper.centerBottom((Container)SwingScatterPlotMatrixView.this.nativeComponent.getNativeComponent(), (Component)SwingScatterPlotMatrixView.this.unregisteredPanel);
                }
            };
            ((ScatterPlotMatrixLayeredPane)this.nativeComponent.getNativeComponent()).addComponentListener(this.unregisteredPanelListener);
        }
    }

    public void createOverplots() {
        if (this.scatterPlotMatrixComponent != null) {
            this.scatterPlotMatrixComponent.createOverplots();
            this.scatterPlotMatrixComponent.scheduleUpdate();
        }
    }

    private class ScatterPlotMatrixLayeredPane
    extends JLayeredPane {
        private ScatterPlotMatrixLayeredPane() {
        }

        @Override
        public boolean requestFocusInWindow(boolean temporary) {
            return super.requestFocusInWindow(temporary);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2;
            long current = System.currentTimeMillis();
            Object antialias = (g2 = (Graphics2D)g).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias != null ? antialias : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            super.paint(g);
            if (((Boolean)SwingScatterPlotMatrixView.this.getShowTiming().getValue()).booleanValue()) {
                g.setColor(Color.red);
                g.drawString(System.currentTimeMillis() - current + " milliseconds", 5, this.getSize().height - 25);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(SwingScatterPlotMatrixView.this.getModel().getAxisCount() * 30, SwingScatterPlotMatrixView.this.getModel().getAxisCount() * 30);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

