/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.treetable.swing;

import com.macrofocus.high_d.treetable.swing.SwingTreeTable;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    protected int visibleRow;
    private SwingTreeTable treeTable;

    public TreeTableCellRenderer(SwingTreeTable treeTable, TreeModel model) {
        super(model);
        this.treeTable = treeTable;
        this.setRowHeight(this.getRowHeight());
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (rowHeight > 0) {
            super.setRowHeight(rowHeight);
            if (this.treeTable != null && this.treeTable.getRowHeight() != rowHeight) {
                this.treeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.treeTable.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(g);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        this.visibleRow = row;
        return this;
    }
}

