/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.syntheticaaddons.ui.painter.TaskPanePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneContainerUI;

public class TaskPaneContainerUI
extends BasicTaskPaneContainerUI {
    protected JXTaskPaneContainer container;
    protected boolean useGradient;
    protected Color gradientStart;
    protected Color gradientEnd;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("name".equals(name)) {
                TaskPaneContainerUI.this.container.setLayout(TaskPaneContainerUI.this.createDefaultLayout());
                TaskPaneContainerUI.this.container.setBorder(TaskPaneContainerUI.this.createContainerBorder());
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new TaskPaneContainerUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.container = (JXTaskPaneContainer)c;
        this.container.setBorder(this.createContainerBorder());
        this.container.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"TaskPaneContainer.opaque", (Component)c, (boolean)true));
        if (this.container.getBackground() == null || this.container.getBackground() instanceof ColorUIResource) {
            this.container.setBackground(UIManager.getColor("TaskPaneContainer.background"));
        }
        this.useGradient = UIManager.getBoolean("TaskPaneContainer.useGradient");
        if (this.useGradient) {
            this.gradientStart = UIManager.getColor("TaskPaneContainer.backgroundGradientStart");
            this.gradientEnd = UIManager.getColor("TaskPaneContainer.backgroundGradientEnd");
        }
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners();
    }

    protected void installListeners() {
        this.container.addPropertyChangeListener(this.propertyListener);
    }

    protected void uninstallListeners() {
        this.container.removePropertyChangeListener(this.propertyListener);
    }

    protected void installDefaults() {
    }

    public void paint(Graphics g, JComponent c) {
        if (this.useGradient) {
            Graphics2D g2 = (Graphics2D)g;
            Paint old = g2.getPaint();
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.gradientStart, 0.0f, c.getHeight(), this.gradientEnd);
            g2.setPaint(gradient);
            g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            g2.setPaint(old);
        }
        TaskPanePainter.getInstance().paintTaskPaneContainerBackground(c, new SyntheticaState(), g, 0, 0, c.getWidth(), c.getHeight());
    }

    protected LayoutManager createDefaultLayout() {
        return new BasicTaskPaneContainerUI.VerticalLayoutUIResource((BasicTaskPaneContainerUI)this, SyntheticaLookAndFeel.getInt((String)"Synthetica.taskPane.container.verticalGap", (Component)this.container, (int)14));
    }

    private Border createContainerBorder() {
        Insets ins = SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.container.insets", (Component)this.container, (Insets)new Insets(10, 10, 0, 10), (boolean)true);
        return SyntheticaLookAndFeel.getInstance().createEmptyBorder(ins, false);
    }
}

